/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.modifier.defense;

import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SupremeDensityArmor
extends EtSTBaseModifier
implements ToolStatsModifierHook {
    public static boolean cachedCd = false;
    private static final TinkerDataCapability.TinkerDataKey<Integer> key = TConstruct.createKey((String)"supreme_density");

    protected void registerHooks(ModuleHookMap.Builder builder) {
        super.registerHooks(builder);
        builder.addModule((HookProvider)new ArmorLevelModule(key, false, (TagKey)null));
        builder.addHook((Object)this, ModifierHooks.TOOL_STATS);
    }

    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    public void modifierOnInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        for (int i = 0; i < modifier.getLevel(); ++i) {
            if (cachedCd) continue;
            for (ModifierEntry entry : tool.getModifiers()) {
                cachedCd = true;
                ((InventoryTickModifierHook)entry.getHook(ModifierHooks.INVENTORY_TICK)).onInventoryTick(tool, entry, world, holder, itemSlot, isSelected, isCorrectSlot, stack);
            }
            cachedCd = false;
        }
    }

    public boolean isNoLevels() {
        return true;
    }

    public void addToolStats(IToolContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        ToolStats.ARMOR.multiply(builder, 2.0);
        ToolStats.ARMOR_TOUGHNESS.multiply(builder, 2.0);
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity living = event.getEntity();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(key, (Object)0);
            if (level > 0 && living instanceof Player && event.getSource().m_269533_(DamageTypeTags.f_268738_)) {
                float percent = Math.min(1.0f, 0.4f * (float)level);
                float am = event.getAmount() * percent;
                am = ForgeHooks.onLivingHurt((LivingEntity)living, (DamageSource)event.getSource(), (float)am);
                am = CombatRules.m_19272_((float)am, (float)living.m_21230_(), (float)((float)living.m_21133_(Attributes.f_22285_)));
                am = SupremeDensityArmor.getMagicDR(am + event.getAmount() * (1.0f - percent), event.getSource(), living);
                event.setAmount(am);
            }
        });
    }

    public static float getMagicDR(float amount, DamageSource damageSource, LivingEntity living) {
        int a;
        int b;
        float f;
        float f1;
        float f2;
        if (living.m_21023_(MobEffects.f_19606_) && damageSource.m_269533_(DamageTypeTags.f_268738_) && (f2 = (f1 = amount) - (amount = Math.max((f = amount * (float)(b = 25 - (a = (living.m_21124_(MobEffects.f_19606_).m_19564_() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
            if (living instanceof ServerPlayer) {
                ((ServerPlayer)living).m_6278_(Stats.f_12988_.m_12902_((Object)Stats.f_12934_), Math.round(f2 * 10.0f));
            } else if (damageSource.m_7639_() instanceof ServerPlayer) {
                ((ServerPlayer)damageSource.m_7639_()).m_6278_(Stats.f_12988_.m_12902_((Object)Stats.f_12930_), Math.round(f2 * 10.0f));
            }
        }
        if (amount <= 0.0f) {
            return 0.0f;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268413_)) {
            return amount;
        }
        a = EnchantmentHelper.m_44856_((Iterable)living.m_6168_(), (DamageSource)damageSource);
        if (a > 0) {
            amount = CombatRules.m_19269_((float)amount, (float)a);
        }
        return amount;
    }

    public int modifierDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        return 0;
    }
}

