/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.modifier.generatorModifiers.energyGeneration;

import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import com.c2h6s.tinkers_advanced.TiAcConfig;
import com.c2h6s.tinkers_advanced.content.modifierHooks.GeneratorModuleModifierHook;
import com.c2h6s.tinkers_advanced.content.modifierHooks.TiAcModifierHooks;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class CombustionGenerator
extends EtSTBaseModifier
implements GeneratorModuleModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, TiAcModifierHooks.GENERATOR_MODULE);
    }

    @Override
    public int getBasicGeneration(IToolStackView tool, ModifierEntry entry) {
        return (Integer)TiAcConfig.COMMON.COMBUSTION_GENERATOR_BASIC_GENERATION.get() * entry.getLevel();
    }

    @Override
    public long shrinkIngredientAndGetTotalEnergy(IToolStackView tool, ModifierEntry entry, @Nullable LivingEntity holderEntity, @Nullable BlockEntity holderBlockEntity, int generateAmount, @NotNull IItemHandler handler) {
        long amount = 0L;
        long required = (long)generateAmount * 20L;
        for (int i = 0; i < 8; ++i) {
            IItemHandlerModifiable itemHandler = (IItemHandlerModifiable)handler;
            ItemStack stack = itemHandler.getStackInSlot(i);
            int burnTime = ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_);
            if (burnTime > 0) {
                long production = (long)burnTime * (long)((Integer)TiAcConfig.COMMON.COMBUSTION_GENERATOR_GENERATION_EACH_BURNING_TIME.get()).intValue();
                int count = Mth.m_14045_((int)Math.round((float)required / (float)production), (int)1, (int)stack.m_41613_());
                ItemStack remaining = ForgeHooks.getCraftingRemainingItem((ItemStack)stack);
                if (!remaining.m_41619_()) {
                    int output = 0;
                    for (int j = 8; j < 16; ++j) {
                        ItemStack leftover = itemHandler.insertItem(j, remaining, true);
                        if (leftover.m_41613_() < remaining.m_41613_()) {
                            output += remaining.m_41613_() - leftover.m_41613_();
                            remaining = itemHandler.insertItem(j, remaining, false);
                        }
                        if (remaining.m_41619_()) break;
                    }
                    count = Math.min(count, output);
                }
                required -= (long)((int)((long)count * production));
                amount += (long)count * production;
                stack.m_41774_(count);
                itemHandler.setStackInSlot(i, stack);
            }
            if (required <= 0L) break;
        }
        return amount;
    }
}

