/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.modifier.harvest;

import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import com.c2h6s.tinkers_advanced.TiAcConfig;
import com.c2h6s.tinkers_advanced.TinkersAdvanced;
import com.c2h6s.tinkers_advanced.util.CommonConstants;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class DisIntegrate
extends EtSTBaseModifier
implements BlockBreakModifierHook,
BreakSpeedModifierHook {
    public static final ResourceLocation KEY_DISINTEGRATE = TinkersAdvanced.getLocation("dis_integrate");

    public Component onModifierRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(KEY_DISINTEGRATE);
        tool.getPersistentData().remove(CommonConstants.KEY_LAST_TICK_1);
        return super.onModifierRemoved(tool, modifier);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.BLOCK_BREAK, ModifierHooks.BREAK_SPEED);
    }

    public void modifierOnInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (tool.getPersistentData().getInt(KEY_DISINTEGRATE) > 0 && !world.f_46443_ && world.m_46467_() % 20L == 0L && (int)(world.m_46467_() % Integer.MAX_VALUE) - tool.getPersistentData().getInt(CommonConstants.KEY_LAST_TICK_1) >= 20 * (Integer)TiAcConfig.COMMON.DISINTEGRATE_EACH_DECREASE.get()) {
            tool.getPersistentData().remove(KEY_DISINTEGRATE);
        }
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifierEntry, ToolHarvestContext toolHarvestContext) {
        if (tool.getPersistentData().getInt(KEY_DISINTEGRATE) < (Integer)TiAcConfig.COMMON.DISINTEGRATE_MAX_BONUS.get()) {
            tool.getPersistentData().putInt(KEY_DISINTEGRATE, tool.getPersistentData().getInt(KEY_DISINTEGRATE) + (Integer)TiAcConfig.COMMON.DISINTEGRATE_EACH_DECREASE.get() * modifierEntry.getLevel());
        }
        tool.getPersistentData().putInt(CommonConstants.KEY_LAST_TICK_1, (int)(toolHarvestContext.getWorld().m_46467_() % Integer.MAX_VALUE));
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifierEntry, PlayerEvent.BreakSpeed breakSpeed, Direction direction, boolean b, float v) {
        if (tool.getPersistentData().getInt(KEY_DISINTEGRATE) > 0) {
            breakSpeed.setNewSpeed(breakSpeed.getNewSpeed() * (1.0f + (float)tool.getPersistentData().getInt(KEY_DISINTEGRATE) / 100.0f));
        }
    }

    public int modifierDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        if (tool.getPersistentData().getInt(KEY_DISINTEGRATE) > 0) {
            float value = (float)amount * (1.0f + (float)tool.getPersistentData().getInt(KEY_DISINTEGRATE) / 200.0f);
            amount = (int)value;
            Random random = new Random();
            if (random.nextFloat() < value - (float)amount) {
                ++amount;
            }
        }
        return amount;
    }

    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, @Nullable RegistryAccess access) {
        return super.getDisplayName().m_6881_().m_130946_(" +" + tool.getPersistentData().getInt(KEY_DISINTEGRATE) + "%");
    }
}

