/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.modifier.harvest;

import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import com.c2h6s.tinkers_advanced.TiAcConfig;
import com.c2h6s.tinkers_advanced.TinkersAdvanced;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.EnchantmentModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ProtoRefining
extends EtSTBaseModifier
implements EnchantmentModifierHook,
BlockBreakModifierHook {
    public static final ResourceLocation KEY_REFINE = TinkersAdvanced.getLocation("key_refining");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.ENCHANTMENTS, ModifierHooks.BLOCK_BREAK);
    }

    public void modifierOnInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ModDataNBT nbt = tool.getPersistentData();
        if (nbt.getInt(KEY_REFINE) > 0 && !world.f_46443_ && world.m_46467_() % 20L == 1L) {
            nbt.putInt(KEY_REFINE, nbt.getInt(KEY_REFINE) - 1);
        }
    }

    public static int getBonus(IToolStackView tool, ModifierEntry entry) {
        ModDataNBT nbt = tool.getPersistentData();
        return Mth.m_14045_((int)(nbt.getInt(KEY_REFINE) / (Integer)TiAcConfig.COMMON.PROTO_REFINING_TIMES_REQUIRED.get()), (int)0, (int)(entry.getLevel() * (Integer)TiAcConfig.COMMON.PROTO_REFINING_BONUS_LEVEL.get()));
    }

    public static void addBonus(IToolStackView tool, ModifierEntry entry) {
        ModDataNBT nbt = tool.getPersistentData();
        nbt.putInt(KEY_REFINE, Math.min(nbt.getInt(KEY_REFINE) + entry.getLevel(), entry.getLevel() * (Integer)TiAcConfig.COMMON.PROTO_REFINING_TIMES_REQUIRED.get() * 2 * (Integer)TiAcConfig.COMMON.PROTO_REFINING_BONUS_LEVEL.get()));
    }

    public int updateEnchantmentLevel(IToolStackView tool, ModifierEntry modifierEntry, Enchantment enchantment, int level) {
        int bonus = ProtoRefining.getBonus(tool, modifierEntry);
        if (bonus > 0 && (enchantment == Enchantments.f_44982_ || enchantment == Enchantments.f_44987_)) {
            level += bonus;
        }
        return level;
    }

    public void updateEnchantments(IToolStackView tool, ModifierEntry modifierEntry, Map<Enchantment, Integer> map) {
        int bonus = ProtoRefining.getBonus(tool, modifierEntry);
        if (bonus > 0) {
            EnchantmentModifierHook.addEnchantment(map, (Enchantment)Enchantments.f_44987_, (int)bonus);
            EnchantmentModifierHook.addEnchantment(map, (Enchantment)Enchantments.f_44982_, (int)bonus);
        }
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifierEntry, ToolHarvestContext toolHarvestContext) {
        ProtoRefining.addBonus(tool, modifierEntry);
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        ProtoRefining.addBonus(tool, modifier);
    }

    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, @Nullable RegistryAccess access) {
        return super.getDisplayName(tool, entry, access).m_6881_().m_130946_(" +" + ProtoRefining.getBonus(tool, entry));
    }
}

