/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.network.packets;

import com.c2h6s.tinkers_advanced.util.ParticleChainUtil;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.client.SafeClientAccess;

public class PParticleChainS2C {
    private final ResourceLocation partId;
    private final Vec3 posStart;
    private final Vec3 posEnd;
    private final float spacing;
    private final String velocityFunctionName;
    private final float velocityFunctionArg;
    private final String offsetFunctionName;
    private final float offsetFunctionArg;
    private final float distanceLimit;
    private final int countLimit;

    public PParticleChainS2C(ParticleType<SimpleParticleType> type, Vec3 posStart, Vec3 posEnd, float spacing, String velocityFunctionName, float velocityFunctionArg, String offsetFunctionName, float offsetFunctionArg, float distanceLimit, int countLimit) {
        this.partId = ForgeRegistries.PARTICLE_TYPES.getKey(type);
        this.posStart = posStart;
        this.posEnd = posEnd;
        this.spacing = spacing;
        this.velocityFunctionName = velocityFunctionName;
        this.velocityFunctionArg = velocityFunctionArg;
        this.offsetFunctionName = offsetFunctionName;
        this.offsetFunctionArg = offsetFunctionArg;
        this.distanceLimit = distanceLimit;
        this.countLimit = countLimit;
    }

    public PParticleChainS2C(FriendlyByteBuf buf) {
        this.partId = buf.m_130281_();
        this.posStart = new Vec3(buf.m_269394_());
        this.posEnd = new Vec3(buf.m_269394_());
        this.spacing = buf.readFloat();
        this.velocityFunctionName = buf.m_130277_();
        this.velocityFunctionArg = buf.readFloat();
        this.offsetFunctionName = buf.m_130277_();
        this.offsetFunctionArg = buf.readFloat();
        this.distanceLimit = buf.readFloat();
        this.countLimit = buf.readInt();
    }

    public void toByte(FriendlyByteBuf buf) {
        buf.m_130085_(this.partId);
        buf.m_269582_(this.posStart.m_252839_());
        buf.m_269582_(this.posEnd.m_252839_());
        buf.writeFloat(this.spacing);
        buf.m_130070_(this.velocityFunctionName);
        buf.writeFloat(this.velocityFunctionArg);
        buf.m_130070_(this.offsetFunctionName);
        buf.writeFloat(this.offsetFunctionArg);
        buf.writeFloat(this.distanceLimit);
        buf.writeInt(this.countLimit);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Level level = SafeClientAccess.getLevel();
            if (level != null) {
                ParticleChainUtil.Client.drawLine((ParticleOptions)ForgeRegistries.PARTICLE_TYPES.getValue(this.partId), (ClientLevel)level, this.posStart, this.posEnd, this.spacing, this.velocityFunctionName, this.velocityFunctionArg, this.offsetFunctionName, this.offsetFunctionArg, this.distanceLimit, this.countLimit);
            }
        });
        return true;
    }
}

