/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.util;

import com.c2h6s.tinkers_advanced.TinkersAdvanced;
import com.c2h6s.tinkers_advanced.network.TiAcPacketHandler;
import com.c2h6s.tinkers_advanced.network.packets.PParticleChainS2C;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.function.TriFunction;

public class ParticleChainUtil {
    protected static Map<Long, Double> doubleCache1 = new HashMap<Long, Double>();
    protected static Map<Long, Double> doubleCache2 = new HashMap<Long, Double>();
    protected static Map<Long, Double> doubleCache3 = new HashMap<Long, Double>();
    protected static Map<String, TriFunction<Double, Long, Vec3, Vec3>> functionMap = ParticleChainUtil.initMap();

    protected static Map<String, TriFunction<Double, Long, Vec3, Vec3>> initMap() {
        functionMap = new HashMap<String, TriFunction<Double, Long, Vec3, Vec3>>();
        Arrays.stream(EnumParticleFunctions.values()).forEach(enumParticleFunctions -> functionMap.put(enumParticleFunctions.name, enumParticleFunctions.function));
        return functionMap;
    }

    public static void drawLine(ParticleType<SimpleParticleType> type, Vec3 posStart, Vec3 posEnd, double spacing, String velocityFunction, double velocityMultiplier, String offsetFunction, double offsetMultiplier, double distanceLimit, int countLimit) {
        TiAcPacketHandler.sendToClient(new PParticleChainS2C(type, posStart, posEnd, (float)spacing, velocityFunction, (float)velocityMultiplier, offsetFunction, (float)offsetMultiplier, (float)distanceLimit, countLimit));
    }

    public static enum EnumParticleFunctions {
        ZERO("zero", (TriFunction<Double, Long, Vec3, Vec3>)((TriFunction)(d, l, vec3) -> Vec3.f_82478_)),
        RANDOM("random", (TriFunction<Double, Long, Vec3, Vec3>)((TriFunction)(d, l, vec3) -> {
            Random random = new Random();
            return new Vec3(random.nextDouble() * 2.0 - 1.0, random.nextDouble() * 2.0 - 1.0, random.nextDouble() * 2.0 - 1.0);
        }));

        public final String name;
        public final TriFunction<Double, Long, Vec3, Vec3> function;

        private EnumParticleFunctions(String name, TriFunction<Double, Long, Vec3, Vec3> function) {
            this.name = name;
            this.function = function;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        public static void drawLine(ParticleOptions options, ClientLevel level, Vec3 posStart, Vec3 posEnd, double spacing, TriFunction<Double, Long, Vec3, Vec3> velocityFunction, double velocityArg, TriFunction<Double, Long, Vec3, Vec3> offsetFunction, double offsetArg, double distanceLimit, int countLimit, long randomSeed) {
            Vec3 vec3 = posEnd.m_82546_(posStart);
            int partsAdded = 0;
            Vec3 direction = vec3.m_82541_();
            for (double d = 0.0; d < Math.min(vec3.m_82553_(), distanceLimit); d += spacing) {
                Vec3 pos = posStart.m_82549_(direction.m_82490_(d)).m_82549_(((Vec3)offsetFunction.apply((Object)d, (Object)randomSeed, (Object)direction)).m_82490_(offsetArg));
                Vec3 velocity = ((Vec3)velocityFunction.apply((Object)d, (Object)randomSeed, (Object)direction)).m_82490_(velocityArg);
                level.m_7106_(options, pos.f_82479_, pos.f_82480_, pos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
                if (++partsAdded > countLimit) break;
            }
        }

        public static void drawLine(ParticleOptions options, ClientLevel level, Vec3 posStart, Vec3 posEnd, double spacing, String velocityFunction, double velocityArg, String offsetFunction, double offsetArg, double distanceLimit, int countLimit) {
            if (functionMap.get(velocityFunction) == null) {
                TinkersAdvanced.LOGGER.error("Invalid function name : {}", (Object)velocityFunction);
                return;
            }
            if (functionMap.get(offsetFunction) == null) {
                TinkersAdvanced.LOGGER.error("Invalid function name : {}", (Object)offsetFunction);
                return;
            }
            Random random = new Random();
            Client.drawLine(options, level, posStart, posEnd, spacing, functionMap.get(velocityFunction), velocityArg, functionMap.get(offsetFunction), offsetArg, distanceLimit, countLimit, random.nextLong());
        }
    }
}

