/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.entity.ai.goal;

import com.matthewperiut.clay.entity.horse.HorseDollEntity;
import com.matthewperiut.clay.entity.soldier.SoldierDollEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;

public class FindDollMountGoal
extends Goal {
    protected final SoldierDollEntity mob;
    private final double speed;
    private Path path;
    private HorseDollEntity target;
    private long lastUpdateTime;
    private int cooldown;

    public FindDollMountGoal(SoldierDollEntity mob, double speed) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.mob = mob;
        this.speed = speed;
    }

    public HorseDollEntity getGoal() {
        Level world = this.mob.m_9236_();
        AABB box = new AABB(this.mob.m_20182_().m_82492_(8.0, 4.0, 8.0), this.mob.m_20182_().m_82520_(8.0, 4.0, 8.0));
        List horses = world.m_6443_(HorseDollEntity.class, box, horse -> !horse.m_20160_());
        double distance = 1000.0;
        HorseDollEntity chosen = null;
        for (HorseDollEntity horse2 : horses) {
            if (this.mob.m_217043_().m_188501_() < 0.33f) {
                return horse2;
            }
            double d = this.mob.m_20275_(horse2.m_20185_(), horse2.m_20186_(), horse2.m_20189_());
            if (!(d < distance)) continue;
            chosen = horse2;
        }
        return chosen;
    }

    public boolean m_8036_() {
        if (this.mob.m_20159_()) {
            return false;
        }
        long currentWorldTime = this.mob.m_9236_().m_46467_();
        if (currentWorldTime - this.lastUpdateTime < 20L) {
            return false;
        }
        this.lastUpdateTime = currentWorldTime;
        this.target = this.getGoal();
        if (this.target == null) {
            return false;
        }
        if (!this.target.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)this.target, 0);
        if (this.path != null) {
            return true;
        }
        return this.getSquaredMaxRideDistance((LivingEntity)this.target) >= this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speed);
        this.cooldown = 0;
    }

    public boolean m_8045_() {
        if (this.target == null) {
            return false;
        }
        if (!this.target.m_6084_()) {
            return false;
        }
        if (this.target.m_20160_()) {
            return false;
        }
        return this.mob.m_21444_(this.target.m_20183_());
    }

    public void m_8041_() {
        if (!EntitySelector.f_20406_.test(this.target)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        HorseDollEntity goalMob = this.target;
        if (goalMob != null) {
            this.mob.m_21563_().m_24960_((Entity)goalMob, 30.0f, 30.0f);
            double d = this.mob.m_20275_(goalMob.m_20185_(), goalMob.m_20186_(), goalMob.m_20189_());
            if (this.mob.m_217043_().m_188501_() < 0.25f) {
                this.mob.m_21573_().m_5624_((Entity)goalMob, this.speed);
            }
            if (this.mob.m_217043_().m_188501_() < 0.05f) {
                this.target = this.getGoal();
                return;
            }
            this.cooldown = Math.max(this.cooldown - 1, 0);
            this.ride(goalMob, d);
        }
    }

    protected void ride(HorseDollEntity target, double squaredDistance) {
        double d = this.getSquaredMaxRideDistance((LivingEntity)target);
        if (squaredDistance <= d && this.cooldown <= 0 && this.m_8045_() && target.f_19797_ > 40) {
            this.mob.m_20329_((Entity)target);
        }
    }

    protected double getSquaredMaxRideDistance(LivingEntity entity) {
        return 2.0;
    }

    protected void resetCooldown() {
        this.cooldown = this.m_183277_(20);
    }

    protected boolean isCooledDown() {
        return this.cooldown <= 0;
    }

    protected int getCooldown() {
        return this.cooldown;
    }

    protected int getMaxCooldown() {
        return this.m_183277_(20);
    }
}

