/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class MeleeAttackTinyGoal
extends Goal {
    protected final PathfinderMob mob;
    private final double speed;
    private final boolean pauseWhenMobIdle;
    private Path path;
    private long lastUpdateTime;

    public MeleeAttackTinyGoal(PathfinderMob mob, double speed, boolean pauseWhenMobIdle) {
        this.mob = mob;
        this.speed = speed;
        this.pauseWhenMobIdle = pauseWhenMobIdle;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long l = this.mob.m_9236_().m_46467_();
        if (l - this.lastUpdateTime < 20L) {
            return false;
        }
        this.lastUpdateTime = l;
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getSquaredMaxAttackDistance(livingEntity) >= this.mob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        if (!this.mob.m_21444_(livingEntity.m_20183_())) {
            return false;
        }
        return !(livingEntity instanceof Player) || !livingEntity.m_5833_() && !((Player)livingEntity).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speed);
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingEntity)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    private void pushTowardOther(Vec3 direction, double mod) {
        PathfinderMob mob = this.mob;
        if (mob.m_20159_()) {
            mob = mob.m_20202_();
        }
        double x = direction.m_7096_();
        double y = direction.m_7098_();
        double z = direction.m_7094_();
        double length = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
        mob.m_5997_(x / length * mod, y / length * mod, z / length * mod);
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity != null) {
            this.mob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
            double d = this.mob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
            if (this.mob.m_21574_().m_148306_((Entity)livingEntity)) {
                this.mob.m_21573_().m_5624_((Entity)livingEntity, this.speed);
                this.pushTowardOther(livingEntity.m_20182_().m_82546_(this.mob.m_20182_()), 0.0125);
            }
            this.attack(livingEntity, d);
        }
    }

    protected void attack(LivingEntity target, double squaredDistance) {
        double d = this.getSquaredMaxAttackDistance(target);
        if (squaredDistance <= d) {
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.m_7327_((Entity)target);
        }
    }

    protected double getSquaredMaxAttackDistance(LivingEntity entity) {
        return 1.0;
    }
}

