/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.entity.ai.goal;

import com.matthewperiut.clay.entity.horse.HorseDollEntity;
import com.matthewperiut.clay.entity.soldier.SoldierDollEntity;
import com.matthewperiut.clay.upgrade.UpgradeManager;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public abstract class SoldierAIFindTarget<T extends Entity>
extends Goal {
    protected final SoldierDollEntity soldier;
    protected final EntityTypeTest<Entity, T> typeFilter;
    protected T target = null;
    protected int tickDelay = 20;

    public SoldierAIFindTarget(SoldierDollEntity soldier, EntityTypeTest<Entity, T> filter) {
        this.soldier = soldier;
        this.typeFilter = filter;
    }

    public boolean m_8036_() {
        return this.soldier.getFollowingEntity() == null;
    }

    public void m_8037_() {
        this.findTarget();
    }

    public void m_8041_() {
        this.target = null;
    }

    protected void findTarget() {
        if (this.tickDelay-- > 0) {
            return;
        }
        this.tickDelay = 20;
        AABB box = new AABB(this.soldier.m_20182_().m_82492_(8.0, 4.0, 8.0), this.soldier.m_20182_().m_82520_(8.0, 4.0, 8.0));
        Level world = this.soldier.m_9236_();
        List targets = world.m_142425_(this.typeFilter, box, this::isTargetable);
        if (targets.isEmpty()) {
            return;
        }
        this.target = (Entity)targets.get(this.soldier.m_217043_().m_216339_(0, targets.size()));
        this.soldier.setFollowingEntity((Entity)this.target);
    }

    protected abstract boolean isTargetable(T var1);

    public static class Upgrade
    extends SoldierAIFindTarget<ItemEntity> {
        public Upgrade(SoldierDollEntity soldier, EntityTypeTest<Entity, ItemEntity> filter) {
            super(soldier, filter);
        }

        @Override
        protected boolean isTargetable(ItemEntity searchTarget) {
            return UpgradeManager.INSTANCE.canApplyUpdate(this.soldier, searchTarget.m_32055_());
        }

        @Override
        public boolean m_8036_() {
            return !this.soldier.maxedOutUpgrades() && super.m_8036_();
        }
    }

    public static class Mount
    extends SoldierAIFindTarget<HorseDollEntity> {
        public Mount(SoldierDollEntity soldier, EntityTypeTest<Entity, HorseDollEntity> filter) {
            super(soldier, filter);
        }

        @Override
        protected boolean isTargetable(HorseDollEntity searchTarget) {
            return searchTarget.m_6084_() && !searchTarget.m_20160_() && searchTarget.m_142582_((Entity)this.soldier);
        }

        @Override
        public boolean m_8036_() {
            return !this.soldier.m_20159_() && super.m_8036_();
        }
    }
}

