/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.entity.ai.goal;

import com.matthewperiut.clay.entity.horse.HorseDollEntity;
import com.matthewperiut.clay.entity.soldier.SoldierDollEntity;
import com.matthewperiut.clay.upgrade.UpgradeManager;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;

public abstract class SoliderAIFollowTarget
extends Goal {
    protected final SoldierDollEntity soldier;
    protected double speed;

    public SoliderAIFollowTarget(SoldierDollEntity soldier, double speed) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.soldier = soldier;
        this.speed = speed;
    }

    public boolean m_8036_() {
        Entity target = this.getTarget();
        return target != null && target.m_6084_() && this.hasValidTarget();
    }

    public void m_8037_() {
        Entity target = this.getTarget();
        this.soldier.m_21563_().m_24960_(target, 30.0f, 30.0f);
        double distanceToTarget = this.soldier.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        if (this.soldier.m_217043_().m_188501_() < 0.25f) {
            this.soldier.m_21573_().m_5624_(target, this.speed);
        }
        this.action(distanceToTarget);
    }

    public void m_8041_() {
        this.cleanUp();
    }

    abstract void action(double var1);

    abstract Entity getTarget();

    abstract boolean hasValidTarget();

    abstract void cleanUp();

    public static class Upgrade
    extends SoliderAIFollowTarget {
        public Upgrade(SoldierDollEntity soldier, double speed) {
            super(soldier, speed);
        }

        @Override
        void action(double distanceToTarget) {
            if (distanceToTarget <= 2.0) {
                ItemEntity target = this.getTarget();
                UpgradeManager.INSTANCE.applyUpdate(this.soldier, target.m_32055_());
                target.m_32055_().m_41774_(1);
                this.soldier.m_9236_().m_6263_(null, this.soldier.m_20185_(), this.soldier.m_20186_(), this.soldier.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((this.soldier.m_217043_().m_188501_() - this.soldier.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
                if (target.m_32055_().m_41613_() == 0) {
                    target.m_32065_();
                }
                this.cleanUp();
            }
        }

        ItemEntity getTarget() {
            if (this.soldier.getFollowingEntity() instanceof ItemEntity) {
                return (ItemEntity)this.soldier.getFollowingEntity();
            }
            return null;
        }

        @Override
        boolean hasValidTarget() {
            return this.getTarget() != null && this.getTarget().m_32055_().m_41613_() >= 1;
        }

        @Override
        void cleanUp() {
            this.soldier.setFollowingEntity(null);
        }
    }

    public static class Mount
    extends SoliderAIFollowTarget {
        public Mount(SoldierDollEntity soldier, double speed) {
            super(soldier, speed);
        }

        @Override
        public Entity getTarget() {
            return this.soldier.getFollowingEntity();
        }

        @Override
        boolean hasValidTarget() {
            Entity target = this.getTarget();
            return target instanceof HorseDollEntity && !target.m_20160_();
        }

        @Override
        void cleanUp() {
            this.soldier.setFollowingEntity(null);
        }

        @Override
        void action(double distanceToTarget) {
            Entity target = this.getTarget();
            if (distanceToTarget <= 2.0 && target.f_19797_ > 20) {
                this.soldier.m_20329_(target);
                this.cleanUp();
            }
        }
    }
}

