/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.entity.soldier;

import com.matthewperiut.clay.entity.ai.goal.MeleeAttackTinyGoal;
import com.matthewperiut.clay.entity.ai.goal.SoldierAIFindTarget;
import com.matthewperiut.clay.entity.ai.goal.SoliderAIFollowTarget;
import com.matthewperiut.clay.entity.horse.HorseDollEntity;
import com.matthewperiut.clay.entity.soldier.teams.ITeam;
import com.matthewperiut.clay.extension.ISpawnReasonExtension;
import com.matthewperiut.clay.nbt.NBTValues;
import com.matthewperiut.clay.network.packet.SyncUpgradesS2CPacket;
import com.matthewperiut.clay.registry.TeamRegistry;
import com.matthewperiut.clay.upgrade.ISoldierUpgrade;
import com.matthewperiut.clay.upgrade.UpgradeInstance;
import com.matthewperiut.clay.upgrade.UpgradeManager;
import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SoldierDollEntity
extends PathfinderMob
implements GeoAnimatable,
EntitySpawnExtension {
    public static final ResourceLocation TEXTURE_ID = new ResourceLocation("clay", "textures/entity/soldier/lightgray.png");
    private final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public HashSet<ISoldierUpgrade> upgrades = new HashSet();
    public HashMap<ISoldierUpgrade, UpgradeInstance> upgradeInstances = new HashMap();
    public Queue<ISoldierUpgrade> removeUpgrades = new LinkedList<ISoldierUpgrade>();
    protected boolean isLightBlockUnaffected = false;
    boolean dropBrick = false;
    private Entity followingEntity;
    private ITeam team;
    private boolean isAnimating = false;
    public static final EntityDataAccessor<Boolean> HAS_STICK = SynchedEntityData.m_135353_(SoldierDollEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public SoldierDollEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22283_, 0.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        if (this.m_20159_()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("animation.clay_soldier.ride"));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("animation.clay_soldier.run"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("animation.clay_soldier.idle"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState<SoldierDollEntity> event) {
        if (this.f_20911_) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().thenPlay("animation.clay_soldier.attack"));
            this.f_20911_ = false;
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate), new AnimationController((GeoAnimatable)this, "attackController", 1, this::attackPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    public InteractionResult m_7111_(Player player, Vec3 hitPos, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            this.isAnimating = !this.isAnimating;
        }
        return super.m_7111_(player, hitPos, hand);
    }

    protected void selectTargets() {
        this.f_21346_.m_25352_(3, (Goal)new SoldierAIFindTarget.Mount(this, (EntityTypeTest<Entity, HorseDollEntity>)EntityTypeTest.m_156916_(HorseDollEntity.class)));
        this.f_21346_.m_25352_(3, (Goal)new SoldierAIFindTarget.Upgrade(this, (EntityTypeTest<Entity, ItemEntity>)EntityTypeTest.m_156916_(ItemEntity.class)));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SoldierDollEntity.class, true, e -> {
            if (e instanceof SoldierDollEntity) {
                SoldierDollEntity target = (SoldierDollEntity)((Object)e);
                return !target.getTeam().isinSameTeam(this.getTeam().getTeamId());
            }
            return false;
        }));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackTinyGoal(this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new SoliderAIFollowTarget.Mount(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new SoliderAIFollowTarget.Upgrade(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.selectTargets();
        super.m_8099_();
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_11993_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11997_;
    }

    protected ResourceLocation m_7582_() {
        if (this.dropBrick) {
            return new ResourceLocation("clay:entities/soldier/brick");
        }
        return super.m_7582_();
    }

    public void m_6667_(DamageSource damageSource) {
        if (this.m_20159_()) {
            Objects.requireNonNull(this.m_20202_()).m_6074_();
        }
        if (damageSource.m_269415_().equals((Object)this.m_9236_().m_269111_().m_269387_().m_269415_()) || damageSource.m_269415_().equals((Object)this.m_9236_().m_269111_().m_269233_().m_269415_())) {
            this.dropBrick = true;
        }
        for (ISoldierUpgrade upgrade : this.upgrades) {
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), upgrade.getUpgradeItem()));
        }
        super.m_6667_(damageSource);
    }

    public void m_21335_(Entity target) {
        super.m_21335_(target);
        if (target instanceof SoldierDollEntity) {
            ISoldierUpgrade upgrade;
            SoldierDollEntity targetSoldier = (SoldierDollEntity)target;
            this.upgrades.forEach(u -> u.onAttack(targetSoldier, this));
            while ((upgrade = this.removeUpgrades.poll()) != null) {
                UpgradeManager.INSTANCE.removeUpgrade(this, upgrade);
            }
        }
    }

    public void m_269138_(DamageSource damageSource) {
        super.m_269138_(damageSource);
    }

    public boolean m_7313_(Entity attacker) {
        if (attacker instanceof Player) {
            this.m_6074_();
        }
        if (attacker instanceof SoldierDollEntity) {
            ISoldierUpgrade upgrade;
            SoldierDollEntity attackerSoldier = (SoldierDollEntity)attacker;
            this.upgrades.forEach(u -> u.onHit(attackerSoldier, this));
            while ((upgrade = this.removeUpgrades.poll()) != null) {
                UpgradeManager.INSTANCE.removeUpgrade(this, upgrade);
            }
        }
        return super.m_7313_(attacker);
    }

    public boolean m_7327_(Entity target) {
        this.m_6674_(InteractionHand.MAIN_HAND);
        return super.m_7327_(target);
    }

    public boolean m_8023_() {
        if (this instanceof ISpawnReasonExtension) {
            return ((ISpawnReasonExtension)((Object)this)).clay$getSpawnReason() == MobSpawnType.SPAWN_EGG;
        }
        return super.m_8023_();
    }

    public Entity getFollowingEntity() {
        return this.followingEntity;
    }

    public void setFollowingEntity(Entity followingEntity) {
        this.followingEntity = followingEntity;
    }

    public boolean maxedOutUpgrades() {
        return false;
    }

    public ITeam getTeam() {
        return this.team;
    }

    public void setTeam(@NotNull ITeam team) {
        this.team = team;
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        short teamId = nbt.m_128448_("Team");
        Optional<Map.Entry> teamOptional = TeamRegistry.SOLDIER_TEAMS.entrySet().stream().filter(t -> ((ITeam)t.getValue()).isinSameTeam(teamId)).findFirst();
        this.setTeam(teamOptional.map(Map.Entry::getValue).orElse((ITeam)TeamRegistry.CLAY_TEAM.get()));
        ListTag nbtListForUpgrades = nbt.m_128437_(NBTValues.SOLDIER_UPGRADES.getKey(), 10);
        for (int i = 0; i < nbtListForUpgrades.size(); ++i) {
            CompoundTag nbtCompound = nbtListForUpgrades.m_128728_(i);
            ResourceLocation identifier = new ResourceLocation(nbtCompound.m_128461_(NBTValues.SOLDIER_UPGRADES_ID.getKey()));
            UpgradeManager.INSTANCE.handleNBTRead(this, identifier, nbtCompound);
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128376_("Team", this.getTeam().getTeamId());
        ListTag nbtListForUpgrades = new ListTag();
        for (ISoldierUpgrade upgrade : this.upgrades) {
            CompoundTag nbtElement = new CompoundTag();
            UpgradeManager.INSTANCE.handleNBTWrite(this, upgrade, nbtElement);
            nbtListForUpgrades.add((Object)nbtElement);
        }
        nbt.m_128365_(NBTValues.SOLDIER_UPGRADES.getKey(), (Tag)nbtListForUpgrades);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        SyncUpgradesS2CPacket syncUpgradeData = new SyncUpgradesS2CPacket(this);
        syncUpgradeData.write(buf);
    }

    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        SyncUpgradesS2CPacket syncUpgradeData = new SyncUpgradesS2CPacket(buf);
        this.upgrades = new HashSet<ISoldierUpgrade>(syncUpgradeData.getUpgrades());
        this.upgrades.forEach(u -> u.onAdd(this));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isLightBlockUnaffected() {
        return this.isLightBlockUnaffected;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setLightBlockUnaffected(boolean lightBlockUnaffected) {
        this.isLightBlockUnaffected = lightBlockUnaffected;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_STICK, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 20 == 0 && this.m_21205_().m_150930_(Items.f_42398_)) {
            this.f_19804_.m_135381_(HAS_STICK, (Object)true);
        }
    }
}

