/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.item.common;

import com.matthewperiut.clay.entity.soldier.SoldierDollEntity;
import com.matthewperiut.clay.entity.soldier.teams.ITeam;
import com.matthewperiut.clay.registry.TeamRegistry;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class SpawnDollItem
extends Item {
    public ArrayList<Supplier<EntityType<?>>> types;

    public SpawnDollItem(ArrayList<Supplier<EntityType<?>>> types, Item.Properties settings) {
        super(settings);
        this.types = types;
    }

    public SpawnDollItem(Supplier<EntityType<?>> defaultType, Item.Properties settings) {
        super(settings);
        this.types = new ArrayList();
        this.types.add(defaultType);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = context.m_43722_();
        BlockPos blockPos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockState = world.m_8055_(blockPos);
        BlockPos blockPos2 = blockState.m_60812_((BlockGetter)world, blockPos).m_83281_() ? blockPos : blockPos.m_121945_(direction);
        int count = itemStack.m_41613_();
        EntityType<?> entityType2 = this.getEntityType(itemStack.m_41783_());
        ITeam team = this.getTeam(itemStack);
        for (int i = 0; i < count; ++i) {
            Entity entity = entityType2.m_20592_((ServerLevel)world, itemStack, context.m_43723_(), blockPos2, MobSpawnType.SPAWN_EGG, false, !Objects.equals(blockPos, blockPos2) && direction == Direction.UP);
            if (entity == null) continue;
            itemStack.m_41774_(1);
            world.m_142346_((Entity)context.m_43723_(), GameEvent.f_157810_, blockPos);
            world.m_5594_(context.m_43723_(), blockPos, SoundEvents.f_11993_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!(entity instanceof SoldierDollEntity)) continue;
            SoldierDollEntity soldier = (SoldierDollEntity)entity;
            soldier.setTeam(team);
        }
        return InteractionResult.CONSUME;
    }

    public ITeam getTeam(ItemStack stack) {
        Optional<Map.Entry> teamOptional = TeamRegistry.SOLDIER_TEAMS.entrySet().stream().filter(entry -> stack.m_150930_(((ITeam)entry.getValue()).getTeamItem().m_41720_())).findFirst();
        return teamOptional.map(Map.Entry::getValue).orElse((ITeam)TeamRegistry.CLAY_TEAM.get());
    }

    public EntityType<?> getEntityType(@Nullable CompoundTag nbt) {
        CompoundTag nbtCompound;
        if (this.types.isEmpty()) {
            return null;
        }
        if (nbt != null && nbt.m_128425_("EntityTag", 10) && (nbtCompound = nbt.m_128469_("EntityTag")).m_128425_("id", 8)) {
            return EntityType.m_20632_((String)nbtCompound.m_128461_("id")).orElse(this.types.get(0).get());
        }
        if (this.types.size() == 1) {
            return this.types.get(0).get();
        }
        int selected = RandomSource.m_216343_().m_216332_(0, this.types.size() - 1);
        return this.types.get(selected).get();
    }
}

