/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.item.disruptor;

import com.matthewperiut.clay.entity.horse.HorseDollEntity;
import com.matthewperiut.clay.entity.soldier.SoldierDollEntity;
import com.matthewperiut.clay.item.disruptor.ClayMaterial;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DisruptorItem
extends TieredItem {
    boolean unlimited = false;

    public DisruptorItem(Tier material, Item.Properties settings) {
        super(material, settings);
    }

    public DisruptorItem(Item.Properties settings) {
        super((Tier)new ClayMaterial(), settings);
        this.unlimited = true;
    }

    public boolean killClayEntity(Level world, Vec3 pos) {
        AABB area = new AABB(pos.m_82546_(new Vec3(16.0, 16.0, 16.0)), pos.m_82549_(new Vec3(16.0, 16.0, 16.0)));
        List entityList = world.m_45933_(null, area);
        boolean found = false;
        for (Entity entity : entityList) {
            if (!(entity instanceof SoldierDollEntity) && !(entity instanceof HorseDollEntity)) continue;
            entity.m_6074_();
            found = true;
        }
        return found;
    }

    public boolean removeClayEntity(Level world, Entity user, ItemStack stack) {
        boolean found = this.killClayEntity(world, user.m_20182_());
        if (found) {
            if (!this.unlimited && stack.m_220157_(1, world.m_213780_(), (ServerPlayer)null)) {
                return true;
            }
            if (user instanceof Player) {
                ((Player)user).m_36335_().m_41524_((Item)this, 20);
                return true;
            }
            Player player = (Player)user;
            if (!this.unlimited) {
                stack.m_41622_(1, (LivingEntity)player, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
            return true;
        }
        return false;
    }

    public boolean removeClayBlock(Level world, Entity user, ItemStack stack) {
        Vec3 pos = user.m_20182_();
        AABB area = new AABB(pos.m_82546_(new Vec3(16.0, 16.0, 16.0)), pos.m_82549_(new Vec3(16.0, 16.0, 16.0)));
        boolean found = false;
        for (int x = (int)area.f_82288_; x <= (int)area.f_82291_; ++x) {
            for (int y = (int)area.f_82289_; y <= (int)area.f_82292_; ++y) {
                for (int z = (int)area.f_82290_; z <= (int)area.f_82293_; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    BlockState blockState = world.m_8055_(blockPos);
                    if (!blockState.m_60734_().m_49966_().equals(Blocks.f_50129_.m_49966_())) continue;
                    world.m_46961_(blockPos, true);
                    found = true;
                }
            }
        }
        if (found) {
            if (!this.unlimited && stack.m_220157_(1, world.m_213780_(), (ServerPlayer)null)) {
                return true;
            }
            if (user instanceof Player) {
                ((Player)user).m_36335_().m_41524_((Item)this, 20);
                return true;
            }
            Player player = (Player)user;
            if (!this.unlimited) {
                stack.m_41622_(1, (LivingEntity)player, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (this.removeClayEntity(world, (Entity)user, itemStack) || this.removeClayBlock(world, (Entity)user, itemStack)) {
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        tooltip.add((Component)Component.m_237115_((String)"item.clay.disruptor.range").m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, world, tooltip, context);
    }
}

