/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.network.client;

import com.matthewperiut.clay.ClayMod;
import com.matthewperiut.clay.entity.soldier.SoldierDollEntity;
import com.matthewperiut.clay.network.UpgradeAdded;
import com.matthewperiut.clay.network.UpgradeRemoved;
import com.matthewperiut.clay.registry.UpgradeRegistry;
import com.matthewperiut.clay.upgrade.ISoldierUpgrade;
import dev.architectury.networking.NetworkManager;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientNetworkHandler {
    public static void init() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)UpgradeAdded.UPGRADE_ADDED_PACKET, (buf, context) -> {
            Optional<SoldierUpgradeContainer> optionalSoldier = ClientNetworkHandler.handleIncomingUpgradePacket(buf, context);
            if (optionalSoldier.isEmpty()) {
                return;
            }
            SoldierUpgradeContainer container = optionalSoldier.get();
            container.soldier.upgrades.add(container.upgrade);
            container.upgrade.onAdd(container.soldier);
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)UpgradeRemoved.UPGRADE_REMOVED_PACKET, (buf, context) -> {
            Optional<SoldierUpgradeContainer> optionalSoldier = ClientNetworkHandler.handleIncomingUpgradePacket(buf, context);
            if (optionalSoldier.isEmpty()) {
                return;
            }
            SoldierUpgradeContainer container = optionalSoldier.get();
            container.soldier.upgrades.remove(container.upgrade);
            container.upgrade.onRemove(container.soldier);
        });
    }

    private static Optional<SoldierUpgradeContainer> handleIncomingUpgradePacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int soldierEntityId = buf.readInt();
        ResourceLocation upgradeIdentifier = buf.m_130281_();
        ISoldierUpgrade upgrade = (ISoldierUpgrade)UpgradeRegistry.SOLDIER_UPGRADE_REGISTER.get(upgradeIdentifier);
        if (upgrade == null) {
            ClayMod.LOGGER.warn("Unknown upgrade id {}", (Object)upgradeIdentifier);
            return Optional.empty();
        }
        Entity entity = context.getPlayer().m_20193_().m_6815_(soldierEntityId);
        if (entity instanceof SoldierDollEntity) {
            SoldierDollEntity soldier = (SoldierDollEntity)entity;
            return Optional.of(new SoldierUpgradeContainer(upgrade, soldier));
        }
        return Optional.empty();
    }

    static class SoldierUpgradeContainer {
        public SoldierDollEntity soldier;
        public ISoldierUpgrade upgrade;

        SoldierUpgradeContainer(ISoldierUpgrade _upgrade, SoldierDollEntity _soldier) {
            this.upgrade = _upgrade;
            this.soldier = _soldier;
        }
    }
}

