/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.network.packet;

import com.matthewperiut.clay.entity.soldier.SoldierDollEntity;
import com.matthewperiut.clay.upgrade.ISoldierUpgrade;
import com.matthewperiut.clay.upgrade.UpgradeManager;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class SyncUpgradesS2CPacket {
    private final List<ISoldierUpgrade> upgrades;

    public SyncUpgradesS2CPacket(SoldierDollEntity entity) {
        this.upgrades = entity.upgrades.stream().filter(ISoldierUpgrade::shouldSyncToClient).toList();
    }

    public SyncUpgradesS2CPacket(FriendlyByteBuf buf) {
        this.upgrades = new LinkedList<ISoldierUpgrade>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.upgrades.add(UpgradeManager.INSTANCE.getUpgrade(buf.m_130281_()));
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.upgrades.size());
        for (ISoldierUpgrade upgrade : this.upgrades) {
            buf.m_130085_(upgrade.getUpgradeIdentifier());
        }
    }

    public List<ISoldierUpgrade> getUpgrades() {
        return this.upgrades;
    }
}

