/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.registry;

import com.matthewperiut.clay.entity.horse.HorseDollEntity;
import com.matthewperiut.clay.entity.soldier.SoldierDollEntity;
import com.matthewperiut.clay.item.common.DollDispenserBehavior;
import com.matthewperiut.clay.item.disruptor.ClayMaterial;
import com.matthewperiut.clay.item.disruptor.DisruptorDispenserBehavior;
import com.matthewperiut.clay.item.disruptor.DisruptorItem;
import com.matthewperiut.clay.item.disruptor.TerracottaMaterial;
import com.matthewperiut.clay.item.horse.HorseDollItem;
import com.matthewperiut.clay.item.soldier.SoldierDollItem;
import com.matthewperiut.clay.registry.EntityTypeRegistry;
import com.matthewperiut.clay.registry.TabsRegistry;
import com.matthewperiut.clay.util.ClientInfoStorage;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"clay", (ResourceKey)BuiltInRegistries.f_257033_.m_123023_());
    public static final DeferredRegister<Item> HORSE_ITEMS = DeferredRegister.create((String)"clay", (ResourceKey)BuiltInRegistries.f_257033_.m_123023_());
    public static final DeferredRegister<Item> MISC_ITEMS = DeferredRegister.create((String)"clay", (ResourceKey)BuiltInRegistries.f_257033_.m_123023_());
    public static final RegistrySupplier<Item> BRICK_SOLDIER = ItemRegistry.registerMiscItem("soldier/brick", () -> new Item(ItemRegistry.miscSettings()));
    public static final RegistrySupplier<Item> CLAY_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/clay", EntityTypeRegistry.CLAY_SOLDIER);
    public static final RegistrySupplier<Item> RED_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/red", EntityTypeRegistry.RED_SOLDIER);
    public static final RegistrySupplier<Item> YELLOW_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/yellow", EntityTypeRegistry.YELLOW_SOLDIER);
    public static final RegistrySupplier<Item> GREEN_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/green", EntityTypeRegistry.GREEN_SOLDIER);
    public static final RegistrySupplier<Item> BLUE_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/blue", EntityTypeRegistry.BLUE_SOLDIER);
    public static final RegistrySupplier<Item> ORANGE_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/orange", EntityTypeRegistry.ORANGE_SOLDIER);
    public static final RegistrySupplier<Item> MAGENTA_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/magenta", EntityTypeRegistry.MAGENTA_SOLDIER);
    public static final RegistrySupplier<Item> LIGHTBLUE_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/lightblue", EntityTypeRegistry.LIGHTBLUE_SOLDIER);
    public static final RegistrySupplier<Item> LIME_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/lime", EntityTypeRegistry.LIME_SOLDIER);
    public static final RegistrySupplier<Item> PINK_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/pink", EntityTypeRegistry.PINK_SOLDIER);
    public static final RegistrySupplier<Item> CYAN_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/cyan", EntityTypeRegistry.CYAN_SOLDIER);
    public static final RegistrySupplier<Item> PURPLE_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/purple", EntityTypeRegistry.PURPLE_SOLDIER);
    public static final RegistrySupplier<Item> BROWN_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/brown", EntityTypeRegistry.BROWN_SOLDIER);
    public static final RegistrySupplier<Item> BLACK_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/black", EntityTypeRegistry.BLACK_SOLDIER);
    public static final RegistrySupplier<Item> GRAY_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/gray", EntityTypeRegistry.GRAY_SOLDIER);
    public static final RegistrySupplier<Item> WHITE_SOLDIER_ITEM = ItemRegistry.registerItem("soldier/white", EntityTypeRegistry.WHITE_SOLDIER);
    public static final RegistrySupplier<Item> BRICK_HORSE = ItemRegistry.registerMiscItem("horse/brick", () -> new Item(ItemRegistry.miscSettings()));
    public static final RegistrySupplier<Item> DIRT_HORSE_ITEM = ItemRegistry.registerHorseDollItem("horse/dirt", EntityTypeRegistry.DIRT_HORSE);
    public static final RegistrySupplier<Item> SAND_HORSE_ITEM = ItemRegistry.registerHorseDollItem("horse/sand", EntityTypeRegistry.SAND_HORSE);
    public static final RegistrySupplier<Item> GRAVEL_HORSE_ITEM = ItemRegistry.registerHorseDollItem("horse/gravel", EntityTypeRegistry.GRAVEL_HORSE);
    public static final RegistrySupplier<Item> FULL_GRASS_HORSE_ITEM = ItemRegistry.registerHorseDollItem("horse/grassy", EntityTypeRegistry.FULL_GRASS_HORSE);
    public static final RegistrySupplier<Item> FULL_SNOW_HORSE_ITEM = ItemRegistry.registerHorseDollItem("horse/snowy", EntityTypeRegistry.FULL_SNOW_HORSE);
    public static final RegistrySupplier<Item> LAPIS_HORSE_ITEM = ItemRegistry.registerHorseDollItem("horse/lapis", EntityTypeRegistry.LAPIS_HORSE);
    public static final RegistrySupplier<Item> CARROT_HORSE_ITEM = ItemRegistry.registerHorseDollItem("horse/carrot", EntityTypeRegistry.CARROT_HORSE);
    public static final RegistrySupplier<Item> CLAY_HORSE_ITEM = ItemRegistry.registerHorseDollItem("horse/clay", EntityTypeRegistry.CLAY_HORSE);
    public static final RegistrySupplier<Item> SOUL_SAND_HORSE_ITEM = ItemRegistry.registerHorseDollItem("horse/soul_sand", EntityTypeRegistry.SOUL_SAND_HORSE);
    public static final RegistrySupplier<Item> CAKE_HORSE_ITEM = ItemRegistry.registerHorseDollItem("horse/cake", EntityTypeRegistry.CAKE_HORSE);
    public static RegistrySupplier<Item> CLAY_DISRUPTOR = ItemRegistry.registerMiscItem("disruptor/clay", () -> new DisruptorItem(new ClayMaterial(), new Item.Properties().m_41487_(1).arch$tab(TabsRegistry.CLAY_MISC_GROUP)));
    public static RegistrySupplier<Item> TERRACOTTA_DISRUPTOR = ItemRegistry.registerMiscItem("disruptor/terracotta", () -> new DisruptorItem(new TerracottaMaterial(), new Item.Properties().m_41487_(1).arch$tab(TabsRegistry.CLAY_MISC_GROUP)));
    public static RegistrySupplier<Item> OBSIDIAN_DISRUPTOR = ItemRegistry.registerMiscItem("disruptor/obsidian", () -> new DisruptorItem(new Item.Properties().m_41487_(1).arch$tab(TabsRegistry.CLAY_MISC_GROUP)));

    public static void init() {
        ITEMS.register();
        HORSE_ITEMS.register();
        MISC_ITEMS.register();
    }

    public static void post() {
        HORSE_ITEMS.forEach(e -> DispenserBlock.m_52672_((ItemLike)((ItemLike)e.get()), (DispenseItemBehavior)DollDispenserBehavior.DOLL_DISPENSE));
        ITEMS.forEach(e -> DispenserBlock.m_52672_((ItemLike)((ItemLike)e.get()), (DispenseItemBehavior)DollDispenserBehavior.DOLL_DISPENSE));
        DisruptorDispenserBehavior dispenserBehavior = new DisruptorDispenserBehavior();
        DispenserBlock.m_52672_((ItemLike)((ItemLike)CLAY_DISRUPTOR.get()), (DispenseItemBehavior)dispenserBehavior);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)TERRACOTTA_DISRUPTOR.get()), (DispenseItemBehavior)dispenserBehavior);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)OBSIDIAN_DISRUPTOR.get()), (DispenseItemBehavior)dispenserBehavior);
        HorseDollItem dirtHorseItem = (HorseDollItem)((Object)DIRT_HORSE_ITEM.get());
        dirtHorseItem.types.add(() -> EntityTypeRegistry.GRASS_HORSE.get());
        dirtHorseItem.types.add(() -> EntityTypeRegistry.MYCELIUM_HORSE.get());
        dirtHorseItem.types.add(() -> EntityTypeRegistry.SNOW_HORSE.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientRegister() {
        ClientInfoStorage.add(CLAY_SOLDIER_ITEM, 11515334);
        ClientInfoStorage.add(RED_SOLDIER_ITEM, 16076354);
        ClientInfoStorage.add(YELLOW_SOLDIER_ITEM, 15977007);
        ClientInfoStorage.add(GREEN_SOLDIER_ITEM, 5467419);
        ClientInfoStorage.add(BLUE_SOLDIER_ITEM, 3488415);
        ClientInfoStorage.add(ORANGE_SOLDIER_ITEM, 15101456);
        ClientInfoStorage.add(MAGENTA_SOLDIER_ITEM, 12537019);
        ClientInfoStorage.add(LIGHTBLUE_SOLDIER_ITEM, 4174555);
        ClientInfoStorage.add(LIME_SOLDIER_ITEM, 7584282);
        ClientInfoStorage.add(PINK_SOLDIER_ITEM, 15176112);
        ClientInfoStorage.add(CYAN_SOLDIER_ITEM, 1346707);
        ClientInfoStorage.add(PURPLE_SOLDIER_ITEM, 7940779);
        ClientInfoStorage.add(BROWN_SOLDIER_ITEM, 7621163);
        ClientInfoStorage.add(BLACK_SOLDIER_ITEM, 0x18181D);
        ClientInfoStorage.add(GRAY_SOLDIER_ITEM, 5331037);
        ClientInfoStorage.add(WHITE_SOLDIER_ITEM, 14870250);
        ClientInfoStorage.add(DIRT_HORSE_ITEM, 5847605);
        ClientInfoStorage.add(GRAVEL_HORSE_ITEM, 11181982);
        ClientInfoStorage.add(FULL_GRASS_HORSE_ITEM, 2600985);
        ClientInfoStorage.add(FULL_SNOW_HORSE_ITEM, 14478066);
        ClientInfoStorage.add(LAPIS_HORSE_ITEM, 4075196);
        ClientInfoStorage.add(CARROT_HORSE_ITEM, 16607232);
        ClientInfoStorage.add(CLAY_HORSE_ITEM, 9870266);
        ClientInfoStorage.add(SOUL_SAND_HORSE_ITEM, 4798252);
    }

    public static RegistrySupplier<Item> registerItem(String name, RegistrySupplier<EntityType<? extends SoldierDollEntity>> entity) {
        return ITEMS.register(name, () -> new SoldierDollItem(() -> entity.get(), ItemRegistry.settings()));
    }

    public static RegistrySupplier<Item> registerHorseDollItem(String name, RegistrySupplier<EntityType<HorseDollEntity>> entity) {
        return HORSE_ITEMS.register(name, () -> new HorseDollItem(() -> entity.get(), ItemRegistry.settings()));
    }

    public static RegistrySupplier<Item> registerMiscItem(String name, Supplier<Item> item) {
        return MISC_ITEMS.register(name, item);
    }

    private static Item.Properties settings() {
        return new Item.Properties().m_41487_(16).arch$tab(TabsRegistry.CLAY_GROUP);
    }

    private static Item.Properties miscSettings() {
        return new Item.Properties().m_41486_().m_41487_(16).arch$tab(TabsRegistry.CLAY_MISC_GROUP);
    }
}

