/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.registry;

import com.matthewperiut.clay.entity.client.HorseDollRenderer;
import com.matthewperiut.clay.entity.client.SoldierDollRenderer;
import com.matthewperiut.clay.util.ClientInfoStorage;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderRegistry {
    public static void init() {
        for (ClientInfoStorage.RendererDataBundle rendererDataBundle : ClientInfoStorage.rendererDataBundleList) {
            if (rendererDataBundle.type == ClientInfoStorage.RendererType.soldier.ordinal()) {
                EntityRendererRegistry.register(() -> bundle.entityType.get(), ctx -> new SoldierDollRenderer(ctx, bundle.textureID));
            }
            if (rendererDataBundle.type != ClientInfoStorage.RendererType.horse.ordinal()) continue;
            EntityRendererRegistry.register(() -> bundle.entityType.get(), ctx -> new HorseDollRenderer(ctx, bundle.textureID));
        }
        for (ClientInfoStorage.ColoredItemDataBundle coloredItemDataBundle : ClientInfoStorage.coloredItemDataBundleList) {
            ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> bundle.color, (Supplier[])new Supplier[]{coloredItemDataBundle.item});
        }
    }
}

