/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.upgrade;

import com.matthewperiut.clay.entity.soldier.SoldierDollEntity;
import com.matthewperiut.clay.nbt.NBTValues;
import com.matthewperiut.clay.network.UpgradeAdded;
import com.matthewperiut.clay.network.UpgradeRemoved;
import com.matthewperiut.clay.registry.UpgradeRegistry;
import com.matthewperiut.clay.upgrade.ISoldierUpgrade;
import com.matthewperiut.clay.upgrade.UpgradeInstance;
import com.matthewperiut.clay.util.NetworkUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class UpgradeManager {
    public static final UpgradeManager INSTANCE = new UpgradeManager();
    public final HashMap<ItemStack, ISoldierUpgrade> possibleUpgrades = this.getItemUpgrades();

    public void applyUpdate(SoldierDollEntity soldier, ItemStack stack) {
        ISoldierUpgrade upgrade = this.getUpgrade(stack);
        if (upgrade != null && upgrade.canUpgrade(stack, soldier)) {
            soldier.upgrades.add(upgrade);
            if (upgrade.needsCustomData()) {
                soldier.upgradeInstances.put(upgrade, new UpgradeInstance(new CompoundTag()));
            }
            upgrade.onAdd(soldier);
            if (upgrade.shouldSyncToClient()) {
                UpgradeAdded.sendPacket(NetworkUtils.getTrackingPlayers((Entity)soldier), soldier.m_19879_(), UpgradeRegistry.SOLDIER_UPGRADE_REGISTER.getId((Object)upgrade));
            }
        }
    }

    public boolean canApplyUpdate(SoldierDollEntity soldier, ItemStack stack) {
        ISoldierUpgrade upgrade = this.getUpgrade(stack);
        if (upgrade != null) {
            return upgrade.canUpgrade(stack, soldier);
        }
        return false;
    }

    public void removeUpgrade(SoldierDollEntity soldier, ISoldierUpgrade upgrade) {
        upgrade.onRemove(soldier);
        soldier.upgrades.remove(upgrade);
        if (upgrade.needsCustomData()) {
            soldier.upgradeInstances.remove(upgrade);
        }
        this.handleDependencies(soldier, upgrade);
        if (upgrade.shouldSyncToClient()) {
            UpgradeRemoved.sendPacket(NetworkUtils.getTrackingPlayers((Entity)soldier), soldier.m_19879_(), UpgradeRegistry.SOLDIER_UPGRADE_REGISTER.getId((Object)upgrade));
        }
    }

    private void handleDependencies(SoldierDollEntity soldier, ISoldierUpgrade upgrade) {
        if (soldier.upgrades.isEmpty()) {
            return;
        }
        Set dependencies = soldier.upgrades.stream().filter(u -> u.dependentsOn() != null && upgrade.hashCode() == u.dependentsOn().hashCode()).collect(Collectors.toSet());
        if (dependencies.isEmpty()) {
            return;
        }
        for (ISoldierUpgrade dependency : dependencies) {
            this.removeUpgrade(soldier, dependency);
        }
    }

    public void handleNBTRead(SoldierDollEntity soldier, ResourceLocation upgradeId, CompoundTag compound) {
        ISoldierUpgrade upgrade = this.getUpgrade(upgradeId);
        if (upgrade == null) {
            return;
        }
        soldier.upgrades.add(upgrade);
        if (upgrade.needsCustomData()) {
            soldier.upgradeInstances.put(upgrade, new UpgradeInstance(compound));
        }
        upgrade.readCustomNBTData(soldier, compound);
        upgrade.onLoad(soldier);
    }

    public void handleNBTWrite(SoldierDollEntity soldier, ISoldierUpgrade upgrade, CompoundTag compound) {
        compound.m_128359_(NBTValues.SOLDIER_UPGRADES_ID.getKey(), upgrade.getUpgradeIdentifier().toString());
        upgrade.writeCustomNBTData(soldier, compound);
    }

    public ISoldierUpgrade getUpgrade(ItemStack stack) {
        Optional<Map.Entry> optionalEntry = this.possibleUpgrades.entrySet().stream().filter(e -> ((ItemStack)e.getKey()).m_150930_(stack.m_41720_())).findFirst();
        return optionalEntry.map(Map.Entry::getValue).orElse(null);
    }

    public ISoldierUpgrade getUpgrade(ResourceLocation identifier) {
        return (ISoldierUpgrade)UpgradeRegistry.SOLDIER_UPGRADE_REGISTER.get(identifier);
    }

    private HashMap<ItemStack, ISoldierUpgrade> getItemUpgrades() {
        List<ISoldierUpgrade> soldierUpgrades = UpgradeRegistry.SOLDIER_UPGRADE_REGISTER.entrySet().stream().map(Map.Entry::getValue).toList();
        HashMap<ItemStack, ISoldierUpgrade> upgrades = new HashMap<ItemStack, ISoldierUpgrade>();
        for (ISoldierUpgrade soldierUpgrade : soldierUpgrades) {
            upgrades.put(soldierUpgrade.getUpgradeItem(), soldierUpgrade);
        }
        return upgrades;
    }
}

