/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.upgrade.armor;

import com.matthewperiut.clay.entity.soldier.SoldierDollEntity;
import com.matthewperiut.clay.upgrade.ISoldierUpgrade;
import com.matthewperiut.clay.upgrade.behavior.IDurable;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SoldierLeatherUpgrade
implements ISoldierUpgrade,
IDurable {
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("clay", "upgrades/soldier/leather_upgrade");
    protected static final UUID MODIFIER_ID = UUID.randomUUID();
    private static final short durability = 20;

    @Override
    public ItemStack getUpgradeItem() {
        return new ItemStack((ItemLike)Items.f_42454_, 1);
    }

    @Override
    public ResourceLocation getUpgradeIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean shouldSyncToClient() {
        return true;
    }

    @Override
    public boolean needsCustomData() {
        return true;
    }

    @Override
    public boolean canUpgrade(ItemStack itemStack, SoldierDollEntity soldier) {
        return itemStack.m_150930_(Items.f_42454_) && !soldier.upgrades.contains(this);
    }

    @Override
    public void onAdd(SoldierDollEntity soldier) {
        if (soldier.m_9236_().m_5776_()) {
            return;
        }
        soldier.m_216990_(SoundEvents.f_11678_);
        soldier.upgradeInstances.get(this).nbtCompound().m_128376_("durable", (short)20);
        AttributeInstance armorInstance = soldier.m_21051_(Attributes.f_22284_);
        AttributeModifier attributeModifier = new AttributeModifier(MODIFIER_ID, "clay:soldier_leather_upgrade", 3.0, AttributeModifier.Operation.ADDITION);
        if (armorInstance != null && !armorInstance.m_22109_(attributeModifier)) {
            armorInstance.m_22125_(attributeModifier);
        }
    }

    @Override
    public void onRemove(SoldierDollEntity soldier) {
        if (soldier.m_9236_().m_5776_()) {
            return;
        }
        soldier.m_216990_(SoundEvents.f_12018_);
        AttributeInstance armorInstance = soldier.m_21051_(Attributes.f_22284_);
        if (armorInstance != null) {
            armorInstance.m_22120_(MODIFIER_ID);
        }
    }

    @Override
    public void onHit(SoldierDollEntity attacker, SoldierDollEntity soldier) {
        this.reduceNBTDurability(attacker.upgradeInstances.get(this).nbtCompound(), attacker);
        if (this.getDurability(attacker) <= 0) {
            attacker.removeUpgrades.add(this);
        }
    }

    @Override
    public void writeCustomNBTData(SoldierDollEntity soldier, CompoundTag nbt) {
        this.writeNBTDurability(nbt, soldier);
    }

    @Override
    public void readCustomNBTData(SoldierDollEntity soldier, CompoundTag nbt) {
        soldier.upgradeInstances.get(this).nbtCompound().m_128391_(nbt);
    }

    @Override
    public short getDurability(SoldierDollEntity soldier) {
        return soldier.upgradeInstances.get(this).nbtCompound().m_128448_("durable");
    }
}

