/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.upgrade.extension;

import com.matthewperiut.clay.entity.soldier.SoldierDollEntity;
import com.matthewperiut.clay.registry.UpgradeRegistry;
import com.matthewperiut.clay.upgrade.ISoldierUpgrade;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SoldierFlintUpgrade
implements ISoldierUpgrade {
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("clay", "upgrades/soldier/flint_upgrade");
    protected static final UUID MODIFIER_ID = UUID.randomUUID();

    @Override
    public ItemStack getUpgradeItem() {
        return new ItemStack((ItemLike)Items.f_42484_, 1);
    }

    @Override
    public ResourceLocation getUpgradeIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean canUpgrade(ItemStack itemStack, SoldierDollEntity soldier) {
        return !soldier.upgrades.contains(this) && itemStack.m_150930_(Items.f_42484_) && soldier.upgrades.contains(UpgradeRegistry.STICK_UPGRADE.get());
    }

    @Override
    public void onAdd(SoldierDollEntity soldier) {
        soldier.m_216990_(SoundEvents.f_11671_);
        AttributeInstance attackInstance = soldier.m_21051_(Attributes.f_22281_);
        AttributeModifier attributeModifier = new AttributeModifier(MODIFIER_ID, "clay:soldier_flint_upgrade", 1.0, AttributeModifier.Operation.ADDITION);
        if (attackInstance != null && !attackInstance.m_22109_(attributeModifier)) {
            attackInstance.m_22125_(attributeModifier);
        }
    }

    @Override
    public void onRemove(SoldierDollEntity soldier) {
        AttributeInstance attackInstance = soldier.m_21051_(Attributes.f_22281_);
        if (attackInstance != null) {
            attackInstance.m_22127_(MODIFIER_ID);
        }
    }

    @Override
    public ISoldierUpgrade dependentsOn() {
        return (ISoldierUpgrade)UpgradeRegistry.STICK_UPGRADE.get();
    }
}

