/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.upgrade.extension;

import com.matthewperiut.clay.entity.soldier.SoldierDollEntity;
import com.matthewperiut.clay.registry.UpgradeRegistry;
import com.matthewperiut.clay.upgrade.ISoldierUpgrade;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SoldierWoolUpgrade
implements ISoldierUpgrade {
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("clay", "upgrades/soldier/wool_upgrade");
    protected static final UUID MODIFIER_ID = UUID.randomUUID();

    @Override
    public ItemStack getUpgradeItem() {
        return new ItemStack((ItemLike)Items.f_41870_, 1);
    }

    @Override
    public ResourceLocation getUpgradeIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean canUpgrade(ItemStack itemStack, SoldierDollEntity soldier) {
        return itemStack.m_204117_(ItemTags.f_13167_) && soldier.upgrades.contains(UpgradeRegistry.LEATHER_UPGRADE.get()) && !soldier.upgrades.contains(this);
    }

    @Override
    public ISoldierUpgrade dependentsOn() {
        return (ISoldierUpgrade)UpgradeRegistry.LEATHER_UPGRADE.get();
    }

    @Override
    public boolean shouldSyncToClient() {
        return true;
    }

    @Override
    public void onAdd(SoldierDollEntity soldier) {
        if (soldier.m_9236_().m_5776_()) {
            return;
        }
        soldier.m_216990_(SoundEvents.f_12642_);
        AttributeInstance armorInstance = soldier.m_21051_(Attributes.f_22284_);
        AttributeModifier attributeModifier = new AttributeModifier(MODIFIER_ID, "clay:soldier_wool_upgrade", 2.0, AttributeModifier.Operation.ADDITION);
        if (armorInstance != null && !armorInstance.m_22109_(attributeModifier)) {
            armorInstance.m_22125_(attributeModifier);
        }
    }

    @Override
    public void onRemove(SoldierDollEntity soldier) {
        if (soldier.m_9236_().m_5776_()) {
            return;
        }
        AttributeInstance armorInstance = soldier.m_21051_(Attributes.f_22284_);
        if (armorInstance != null) {
            armorInstance.m_22127_(MODIFIER_ID);
        }
    }
}

