/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.upgrade.hand;

import com.matthewperiut.clay.entity.soldier.SoldierDollEntity;
import com.matthewperiut.clay.upgrade.ISoldierUpgrade;
import com.matthewperiut.clay.upgrade.behavior.IDurable;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SoldierStickUpgrade
implements ISoldierUpgrade,
IDurable {
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("clay", "upgrades/soldier/stick_upgrade");
    private static final short durability = 20;
    protected static final UUID MODIFIER_ID = UUID.randomUUID();

    @Override
    public ItemStack getUpgradeItem() {
        return new ItemStack((ItemLike)Items.f_42398_, 1);
    }

    @Override
    public ResourceLocation getUpgradeIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean needsCustomData() {
        return true;
    }

    @Override
    public boolean canUpgrade(ItemStack itemStack, SoldierDollEntity soldier) {
        return !soldier.upgrades.contains(this) && itemStack.m_150930_(Items.f_42398_);
    }

    @Override
    public void onAdd(SoldierDollEntity soldier) {
        soldier.upgradeInstances.get(this).nbtCompound().m_128376_("durable", (short)20);
        soldier.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42398_, 1));
        AttributeInstance attackInstance = soldier.m_21051_(Attributes.f_22281_);
        AttributeModifier attributeModifier = new AttributeModifier(MODIFIER_ID, "clay:soldier_stick_upgrade", 2.0, AttributeModifier.Operation.ADDITION);
        if (attackInstance != null && !attackInstance.m_22109_(attributeModifier)) {
            attackInstance.m_22125_(attributeModifier);
        }
    }

    @Override
    public void onRemove(SoldierDollEntity soldier) {
        soldier.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        AttributeInstance attackInstance = soldier.m_21051_(Attributes.f_22281_);
        if (attackInstance != null) {
            attackInstance.m_22127_(MODIFIER_ID);
        }
        if (this.getDurability(soldier) <= 0) {
            soldier.m_216990_(SoundEvents.f_12018_);
        }
    }

    @Override
    public void onAttack(SoldierDollEntity target, SoldierDollEntity attacker) {
        this.reduceNBTDurability(attacker.upgradeInstances.get(this).nbtCompound(), attacker);
        if (this.getDurability(attacker) <= 0) {
            attacker.removeUpgrades.add(this);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(IDENTIFIER.toString());
    }

    @Override
    public void writeCustomNBTData(SoldierDollEntity soldier, CompoundTag nbt) {
        this.writeNBTDurability(nbt, soldier);
    }

    @Override
    public void readCustomNBTData(SoldierDollEntity soldier, CompoundTag nbt) {
        soldier.upgradeInstances.get(this).nbtCompound().m_128391_(nbt);
    }

    @Override
    public short getDurability(SoldierDollEntity soldier) {
        return soldier.upgradeInstances.get(this).nbtCompound().m_128448_("durable");
    }
}

