/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.clay.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;

public class ClientInfoStorage {
    public static List<RendererDataBundle> rendererDataBundleList = new ArrayList<RendererDataBundle>();
    public static List<ColoredItemDataBundle> coloredItemDataBundleList = new ArrayList<ColoredItemDataBundle>();

    private ClientInfoStorage(Supplier<EntityType<?>> entityType, ResourceLocation textureID, int type) {
        rendererDataBundleList.add(new RendererDataBundle(entityType, textureID, type));
    }

    public static void add(Supplier<EntityType<?>> entityType, ResourceLocation textureID, int type) {
        rendererDataBundleList.add(new RendererDataBundle(entityType, textureID, type));
    }

    public static void clear() {
        rendererDataBundleList.clear();
        coloredItemDataBundleList.clear();
    }

    public static void add(Supplier<Item> item, int color) {
        coloredItemDataBundleList.add(new ColoredItemDataBundle(item, color));
    }

    public static class RendererDataBundle {
        public int type;
        public Supplier<EntityType<?>> entityType;
        public ResourceLocation textureID;

        public RendererDataBundle(Supplier<EntityType<?>> entityType, ResourceLocation textureID, int type) {
            this.type = type;
            this.entityType = entityType;
            this.textureID = textureID;
        }
    }

    public static class ColoredItemDataBundle {
        public Supplier<Item> item;
        public int color;

        private ColoredItemDataBundle(Supplier<Item> item, int color) {
            this.item = item;
            this.color = color;
        }
    }

    public static enum RendererType {
        soldier,
        horse;

    }
}

