/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.vanilladelight.common.block;

import java.util.Optional;
import net.chaolux.vanilladelight.common.block.entity.CommonStoveBlockEntity;
import net.chaolux.vanilladelight.registry.block.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.items.IItemHandler;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class CommonStoveBlock
extends StoveBlock {
    public CommonStoveBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntityTypes.COMMON_STOVE.get()).m_155264_(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? CommonStoveBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.COMMON_STOVE.get()), (BlockEntityTicker)(level.f_46443_ ? CommonStoveBlockEntity::animationTick : CommonStoveBlockEntity::cookingTick)) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity;
        ItemStack heldStack = player.m_21120_(hand);
        Item heldItem = heldStack.m_41720_();
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            if (heldStack.canPerformAction(ToolActions.SHOVEL_DIG)) {
                this.extinguish(state, level, pos);
                heldStack.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            if (heldItem == Items.f_42447_) {
                if (!level.m_5776_()) {
                    level.m_5594_((Player)null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.extinguish(state, level, pos);
                if (!player.m_7500_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            if (heldItem instanceof FlintAndSteelItem) {
                level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, MathUtils.RAND.nextFloat() * 0.4f + 0.8f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                heldStack.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            if (heldItem instanceof FireChargeItem) {
                level.m_5594_((Player)null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, (MathUtils.RAND.nextFloat() - MathUtils.RAND.nextFloat()) * 0.2f + 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                if (!player.m_7500_()) {
                    heldStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if ((tileEntity = level.m_7702_(pos)) instanceof CommonStoveBlockEntity) {
            CommonStoveBlockEntity stoveEntity = (CommonStoveBlockEntity)tileEntity;
            int stoveSlot = stoveEntity.getNextEmptySlot();
            if (stoveSlot < 0 || stoveEntity.isStoveBlockedAbove()) {
                return InteractionResult.PASS;
            }
            Optional<CampfireCookingRecipe> recipe = stoveEntity.getMatchingRecipe((Container)new SimpleContainer(new ItemStack[]{heldStack}), stoveSlot);
            if (recipe.isPresent()) {
                if (!level.f_46443_ && stoveEntity.addItem(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack, recipe.get(), stoveSlot)) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof CommonStoveBlockEntity) {
                CommonStoveBlockEntity stoveBlockEntity = (CommonStoveBlockEntity)tileEntity;
                ItemUtils.dropItems((Level)level, (BlockPos)pos, (IItemHandler)stoveBlockEntity.getInventory());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }
}

