/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.PaintbrushItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.util.DecorationHelper;

public class DecorationTableBlockEntity
extends BlockEntity {
    public static final int TOP_INNER_TRIM_SLOT = 0;
    public static final int TOP_TRIM_SLOT = 1;
    public static final int SIDE_TRIM_SLOT = 2;
    public static final int BOTTOM_TRIM_SLOT = 3;
    public static final int TOP_CORE_SLOT = 4;
    public static final int SIDE_CORE_SLOT = 5;
    public static final int BOTTOM_CORE_SLOT = 6;
    public static final int RED_DYE_SLOT = 0;
    public static final int GREEN_DYE_SLOT = 1;
    public static final int BLUE_DYE_SLOT = 2;
    public static final Set<Item> STORAGES_WIHOUT_TOP_INNER_TRIM = Set.of((Item)ModBlocks.BARREL_ITEM.get(), (Item)ModBlocks.COPPER_BARREL_ITEM.get(), (Item)ModBlocks.IRON_BARREL_ITEM.get(), (Item)ModBlocks.GOLD_BARREL_ITEM.get(), (Item)ModBlocks.DIAMOND_BARREL_ITEM.get(), (Item)ModBlocks.NETHERITE_BARREL_ITEM.get(), (Item)ModBlocks.LIMITED_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get());
    private static final Map<Predicate<ItemStack>, IItemDecorator> ITEM_DECORATORS = new LinkedHashMap<Predicate<ItemStack>, IItemDecorator>();
    private final Map<ResourceLocation, Integer> remainingParts = new HashMap<ResourceLocation, Integer>();
    private final ItemStackHandler decorativeBlocks = new ItemStackHandler(7){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DecorationTableBlockEntity.this.updateResultAndSetChanged();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isItemValid(int slot, ItemStack stack) {
            Item item = stack.m_41720_();
            if (!(item instanceof BlockItem)) return false;
            BlockItem blockItem = (BlockItem)item;
            if (stack.m_41720_() instanceof StorageBlockItem) return false;
            if (!Block.m_49916_((VoxelShape)blockItem.m_40614_().m_49966_().m_60808_((BlockGetter)DecorationTableBlockEntity.this.f_58857_, BlockPos.f_121853_))) return false;
            return true;
        }
    };
    private final ItemStackHandler dyes = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DecorationTableBlockEntity.this.updateResultAndSetChanged();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.m_204117_(Tags.Items.DYES_RED);
                case 1 -> stack.m_204117_(Tags.Items.DYES_GREEN);
                case 2 -> stack.m_204117_(Tags.Items.DYES_BLUE);
                default -> false;
            };
        }
    };
    private ItemStack result = ItemStack.f_41583_;
    private final Map<Integer, Boolean> slotMaterialInheritance = new HashMap<Integer, Boolean>();
    private int accentColor = -1;
    private int mainColor = -1;
    private final Set<ResourceLocation> missingDyes = new HashSet<ResourceLocation>();
    private final ItemStackHandler storageBlock = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DecorationTableBlockEntity.this.updateResultAndSetChanged();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return ITEM_DECORATORS.keySet().stream().anyMatch(predicate -> predicate.test(stack));
        }
    };
    public static final IItemDecorator STORAGE_DECORATOR = new IItemDecorator(){

        @Override
        public boolean supportsMaterials(ItemStack input) {
            return input.m_41720_() instanceof BarrelBlockItem && !DecorationTableBlockEntity.isTintedStorage(input);
        }

        @Override
        public boolean supportsTints(ItemStack input) {
            return !(input.m_41720_() instanceof BarrelBlockItem) || BarrelBlockItem.getMaterials(input).isEmpty();
        }

        @Override
        public boolean supportsTopInnerTrim(ItemStack input) {
            return !STORAGES_WIHOUT_TOP_INNER_TRIM.contains(input.m_41720_());
        }

        @Override
        public ItemStack decorateWithMaterials(ItemStack input, Map<BarrelMaterial, ResourceLocation> materialsToApply) {
            if (materialsToApply.isEmpty()) {
                return ItemStack.f_41583_;
            }
            EnumMap<BarrelMaterial, ResourceLocation> materials = new EnumMap<BarrelMaterial, ResourceLocation>(BarrelMaterial.class);
            materials.putAll(BarrelBlockItem.getMaterials(input));
            BarrelBlockItem.uncompactMaterials(materials);
            materials.putAll(materialsToApply);
            BarrelBlockItem.compactMaterials(materials);
            if (DecorationTableBlockEntity.allMaterialsMatch(materials, BarrelBlockItem.getMaterials(input))) {
                return ItemStack.f_41583_;
            }
            ItemStack result = input.m_255036_(1);
            BarrelBlockItem.removeCoveredTints(result, materials);
            BarrelBlockItem.setMaterials(result, materials);
            return result;
        }

        @Override
        public TintDecorationResult decorateWithTints(ItemStack input, int mainColorToSet, int accentColorToSet) {
            BlockItem blockItem;
            if (DecorationTableBlockEntity.colorsTransparentOrSameAs(input, mainColorToSet, accentColorToSet)) {
                return TintDecorationResult.EMPTY;
            }
            ItemStack result = input.m_255036_(1);
            Item item = result.m_41720_();
            if (item instanceof BlockItem && (blockItem = (BlockItem)item) instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)blockItem;
                if (mainColorToSet != -1) {
                    tintableBlockItem.setMainColor(result, mainColorToSet & 0xFFFFFF);
                }
                if (accentColorToSet != -1) {
                    tintableBlockItem.setAccentColor(result, accentColorToSet & 0xFFFFFF);
                }
            }
            return new TintDecorationResult(result, DecorationTableBlockEntity.calculateRequiredDyes(mainColorToSet, accentColorToSet, StorageBlockItem.getMainColorFromStack(input).orElse(-1), StorageBlockItem.getAccentColorFromStack(input).orElse(-1)));
        }
    };

    public static void registerItemDecorator(Predicate<ItemStack> itemMatcher, IItemDecorator itemDecorator) {
        ITEM_DECORATORS.put(itemMatcher, itemDecorator);
    }

    public void updateResultAndSetChanged() {
        this.updateResult();
        this.m_6596_();
    }

    private void updateResult() {
        this.missingDyes.clear();
        this.result = ItemStack.f_41583_;
        ItemStack input = this.storageBlock.getStackInSlot(0);
        if (input.m_41619_()) {
            return;
        }
        DecorationTableBlockEntity.getItemDecorator(input).ifPresent(itemDecorator -> {
            TintDecorationResult decorationResult = this.decorateItem((IItemDecorator)itemDecorator, input);
            this.result = decorationResult.result();
            this.missingDyes.addAll(this.calculateMissingDyes(decorationResult.requiredDyeParts()));
        });
    }

    private static Optional<IItemDecorator> getItemDecorator(ItemStack input) {
        return ITEM_DECORATORS.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(input)).findFirst().map(Map.Entry::getValue);
    }

    private TintDecorationResult decorateItem(IItemDecorator itemDecorator, ItemStack input) {
        Map<BarrelMaterial, ResourceLocation> materialsToApply;
        if (itemDecorator.supportsMaterials(input) && !(materialsToApply = this.getMaterialsToApply(itemDecorator.supportsTopInnerTrim(input))).isEmpty()) {
            return new TintDecorationResult(itemDecorator.decorateWithMaterials(input, materialsToApply), Collections.emptyMap());
        }
        if (itemDecorator.supportsTints(input)) {
            return itemDecorator.decorateWithTints(input, this.mainColor, this.accentColor);
        }
        return TintDecorationResult.EMPTY;
    }

    public boolean hasMaterials() {
        return !InventoryHelper.isEmpty((IItemHandler)this.decorativeBlocks);
    }

    public List<ItemStack> getDecoratedPreviewStacks() {
        ItemStack input = this.storageBlock.getStackInSlot(0);
        return DecorationTableBlockEntity.getItemDecorator(input).map(itemDecorator -> {
            ArrayList previewStacks = new ArrayList();
            itemDecorator.getPreviewStackInputs(input, this.hasMaterials()).forEach(stack -> DecorationTableBlockEntity.getItemDecorator(stack).ifPresent(inputItemDecorator -> {
                TintDecorationResult decorationResult = this.decorateItem((IItemDecorator)inputItemDecorator, (ItemStack)stack);
                if (!decorationResult.result().m_41619_()) {
                    previewStacks.add(decorationResult.result());
                }
            }));
            return previewStacks;
        }).orElse(Collections.emptyList());
    }

    public static boolean allMaterialsMatch(Map<BarrelMaterial, ResourceLocation> newMaterials, Map<BarrelMaterial, ResourceLocation> currentMaterials) {
        if (newMaterials.size() != currentMaterials.size()) {
            return false;
        }
        for (Map.Entry<BarrelMaterial, ResourceLocation> entry : newMaterials.entrySet()) {
            if (entry.getValue().equals((Object)currentMaterials.get((Object)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private Set<ResourceLocation> calculateMissingDyes(Map<TagKey<Item>, Integer> requiredDyeParts) {
        HashSet<ResourceLocation> missingDyes = new HashSet<ResourceLocation>();
        if (!(this.dyes.getStackInSlot(0).m_41619_() || this.dyes.getStackInSlot(1).m_41619_() || this.dyes.getStackInSlot(2).m_41619_())) {
            return missingDyes;
        }
        Map<ResourceLocation, Integer> partsNeeded = requiredDyeParts.entrySet().stream().map(entry -> Map.entry(((TagKey)entry.getKey()).f_203868_(), (Integer)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<ResourceLocation, Integer> entry2 : partsNeeded.entrySet()) {
            if (entry2.getKey().equals((Object)Tags.Items.DYES_RED.f_203868_()) && this.dyes.getStackInSlot(0).m_41619_()) {
                missingDyes.add(entry2.getKey());
                continue;
            }
            if (entry2.getKey().equals((Object)Tags.Items.DYES_GREEN.f_203868_()) && this.dyes.getStackInSlot(1).m_41619_()) {
                missingDyes.add(entry2.getKey());
                continue;
            }
            if (!entry2.getKey().equals((Object)Tags.Items.DYES_BLUE.f_203868_()) || !this.dyes.getStackInSlot(2).m_41619_()) continue;
            missingDyes.add(entry2.getKey());
        }
        return missingDyes;
    }

    private static Map<TagKey<Item>, Integer> calculateRequiredDyes(int mainColorToSet, int accentColorToSet, int currentMainColor, int currentAccentColor) {
        return DecorationHelper.getDyePartsNeeded(mainColorToSet, accentColorToSet, currentMainColor, currentAccentColor);
    }

    public Set<ResourceLocation> getMissingDyes() {
        return this.missingDyes;
    }

    private void setMaterialsFromDecorativeBlocks(Map<BarrelMaterial, ResourceLocation> materials, boolean supportsInnerTrim) {
        ResourceLocation topInnerTrimMaterialLocation = this.setMaterialFromBlock(0, null, materials, BarrelMaterial.TOP_INNER_TRIM, supportsInnerTrim);
        ResourceLocation topTrimMaterialLocation = this.setMaterialFromBlock(1, topInnerTrimMaterialLocation, materials, BarrelMaterial.TOP_TRIM, true);
        ResourceLocation sideTrimMaterialLocation = this.setMaterialFromBlock(2, topTrimMaterialLocation, materials, BarrelMaterial.SIDE_TRIM, true);
        this.setMaterialFromBlock(3, sideTrimMaterialLocation, materials, BarrelMaterial.BOTTOM_TRIM, true);
        ResourceLocation topMaterialLocation = this.setMaterialFromBlock(4, topTrimMaterialLocation, materials, BarrelMaterial.TOP, true);
        ResourceLocation sideMaterialLocation = this.setMaterialFromBlock(5, topMaterialLocation, materials, BarrelMaterial.SIDE, true);
        this.setMaterialFromBlock(6, sideMaterialLocation, materials, BarrelMaterial.BOTTOM, true);
    }

    @Nullable
    private ResourceLocation setMaterialFromBlock(int slotIndex, @Nullable ResourceLocation defaultMaterialLocation, Map<BarrelMaterial, ResourceLocation> materials, BarrelMaterial material, boolean addToMaterials) {
        ItemStack decorativeBlock = this.decorativeBlocks.getStackInSlot(slotIndex);
        ResourceLocation materialLocation = DecorationHelper.getMaterialLocation(decorativeBlock).orElse((ResourceLocation)(this.isSlotMaterialInherited(slotIndex) ? defaultMaterialLocation : null));
        if (materialLocation != null) {
            if (addToMaterials) {
                materials.put(material, materialLocation);
            }
            return materialLocation;
        }
        return null;
    }

    public DecorationTableBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.DECORATION_TABLE_BLOCK_ENTITY_TYPE.get(), pos, blockState);
    }

    public ItemStackHandler getDecorativeBlocks() {
        return this.decorativeBlocks;
    }

    public ItemStackHandler getDyes() {
        return this.dyes;
    }

    public ItemStackHandler getStorageBlock() {
        return this.storageBlock;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack extractResult(int count) {
        ItemStack result = this.getResult();
        if (result.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack extracted = result.m_41777_();
        extracted.m_41764_(count);
        if (count >= result.m_41613_()) {
            this.result = ItemStack.f_41583_;
        } else {
            result.m_41774_(count);
        }
        this.m_6596_();
        return extracted;
    }

    public boolean isSlotMaterialInherited(int slot) {
        return this.slotMaterialInheritance.getOrDefault(slot, true);
    }

    public ItemStack getInheritedItem(int childSlot) {
        while (this.isSlotMaterialInherited(childSlot)) {
            int parentSlot = this.getSlotInheritedFrom(childSlot);
            if (parentSlot == -1) {
                return ItemStack.f_41583_;
            }
            if (!this.decorativeBlocks.getStackInSlot(parentSlot).m_41619_()) {
                return this.decorativeBlocks.getStackInSlot(parentSlot);
            }
            childSlot = parentSlot;
        }
        return ItemStack.f_41583_;
    }

    public int getSlotInheritedFrom(int slot) {
        return switch (slot) {
            case 1 -> 0;
            case 2 -> 1;
            case 3 -> 2;
            case 4 -> 1;
            case 5 -> 4;
            case 6 -> 5;
            default -> -1;
        };
    }

    public void setSlotMaterialInheritance(int slot, boolean value) {
        if (value) {
            this.slotMaterialInheritance.remove(slot);
        } else {
            this.slotMaterialInheritance.put(slot, false);
        }
        this.updateResultAndSetChanged();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.saveData(tag);
        return tag;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.decorativeBlocks.deserializeNBT(tag.m_128469_("decorativeBlocks"));
        this.dyes.deserializeNBT(tag.m_128469_("dyes"));
        this.storageBlock.deserializeNBT(tag.m_128469_("storageBlock"));
        this.result = tag.m_128441_("result") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("result")) : ItemStack.f_41583_;
        this.slotMaterialInheritance.clear();
        ListTag inheritance = tag.m_128437_("slotMaterialInheritance", 10);
        for (int i = 0; i < inheritance.size(); ++i) {
            CompoundTag slotTag = inheritance.m_128728_(i);
            this.slotMaterialInheritance.put(slotTag.m_128451_("slot"), slotTag.m_128471_("value"));
        }
        this.remainingParts.clear();
        ListTag remainingPartsTag = tag.m_128437_("remainingParts", 10);
        for (int i = 0; i < remainingPartsTag.size(); ++i) {
            CompoundTag partTag = remainingPartsTag.m_128728_(i);
            ResourceLocation key = ResourceLocation.m_135820_((String)partTag.m_128461_("key"));
            if (key == null) continue;
            this.remainingParts.put(key, partTag.m_128451_("value"));
        }
        this.mainColor = tag.m_128451_("mainColor");
        this.accentColor = tag.m_128451_("accentColor");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveData(tag);
    }

    private void saveData(CompoundTag tag) {
        tag.m_128365_("decorativeBlocks", (Tag)this.decorativeBlocks.serializeNBT());
        tag.m_128365_("dyes", (Tag)this.dyes.serializeNBT());
        tag.m_128365_("storageBlock", (Tag)this.storageBlock.serializeNBT());
        if (!this.result.m_41619_()) {
            tag.m_128365_("result", (Tag)this.result.m_41739_(new CompoundTag()));
        }
        ListTag inheritance = new ListTag();
        this.slotMaterialInheritance.forEach((slot, value) -> {
            CompoundTag slotTag = new CompoundTag();
            slotTag.m_128405_("slot", slot.intValue());
            slotTag.m_128379_("value", value.booleanValue());
            inheritance.add((Object)slotTag);
        });
        tag.m_128365_("slotMaterialInheritance", (Tag)inheritance);
        ListTag remainingPartsTag = new ListTag();
        this.remainingParts.forEach((key, value) -> {
            CompoundTag partTag = new CompoundTag();
            partTag.m_128359_("key", key.toString());
            partTag.m_128405_("value", value.intValue());
            remainingPartsTag.add((Object)partTag);
        });
        tag.m_128365_("remainingParts", (Tag)remainingPartsTag);
        tag.m_128405_("mainColor", this.mainColor);
        tag.m_128405_("accentColor", this.accentColor);
    }

    public void consumeIngredientsOnCraft() {
        ItemStack input = this.storageBlock.getStackInSlot(0);
        DecorationTableBlockEntity.getItemDecorator(input).ifPresent(itemDecorator -> {
            if (!itemDecorator.consumesIngredientsOnCraft()) {
                return;
            }
            boolean emptyDecorativeBlocks = InventoryHelper.isEmpty((IItemHandler)this.decorativeBlocks);
            if ((emptyDecorativeBlocks || !itemDecorator.supportsMaterials(input)) && itemDecorator.supportsTints(input)) {
                DecorationHelper.consumeDyes(this.mainColor, this.accentColor, this.remainingParts, List.of(this.dyes), StorageBlockItem.getMainColorFromStack(input).orElse(-1), StorageBlockItem.getAccentColorFromStack(input).orElse(-1), false);
            } else if (!emptyDecorativeBlocks && itemDecorator.supportsMaterials(input)) {
                Map<BarrelMaterial, ResourceLocation> originalMaterials = BarrelBlockItem.getUncompactedMaterials(input);
                DecorationHelper.consumeMaterials(this.remainingParts, List.of(this.decorativeBlocks), originalMaterials, this.getMaterialsToApply(!STORAGES_WIHOUT_TOP_INNER_TRIM.contains(input.m_41720_())), false);
            }
            this.m_6596_();
            WorldHelper.notifyBlockUpdate((BlockEntity)this);
        });
    }

    public Map<ResourceLocation, Integer> getPartsNeeded() {
        HashMap<ResourceLocation, Integer> partsNeeded = new HashMap<ResourceLocation, Integer>();
        ItemStack storageStack = this.storageBlock.getStackInSlot(0);
        if (InventoryHelper.isEmpty((IItemHandler)this.decorativeBlocks) || !(storageStack.m_41720_() instanceof BarrelBlockItem)) {
            DecorationHelper.getDyePartsNeeded(this.mainColor, this.accentColor, StorageBlockItem.getMainColorFromStack(storageStack).orElse(-1), StorageBlockItem.getAccentColorFromStack(storageStack).orElse(-1)).forEach((tag, parts) -> partsNeeded.put(tag.f_203868_(), (Integer)parts));
        } else {
            partsNeeded.putAll(DecorationHelper.getMaterialPartsNeeded(BarrelBlockItem.getUncompactedMaterials(storageStack), this.getMaterialsToApply(!STORAGES_WIHOUT_TOP_INNER_TRIM.contains(storageStack.m_41720_()))));
        }
        return partsNeeded;
    }

    private Map<BarrelMaterial, ResourceLocation> getMaterialsToApply(boolean supportsInnerTrim) {
        EnumMap<BarrelMaterial, ResourceLocation> materialsToApply = new EnumMap<BarrelMaterial, ResourceLocation>(BarrelMaterial.class);
        this.setMaterialsFromDecorativeBlocks(materialsToApply, supportsInnerTrim);
        return materialsToApply;
    }

    public int getMainColor() {
        return this.mainColor;
    }

    public void setMainColor(int mainColor) {
        this.mainColor = mainColor;
        this.updateResultAndSetChanged();
    }

    public int getAccentColor() {
        return this.accentColor;
    }

    public void setAccentColor(int accentColor) {
        this.accentColor = accentColor;
        this.updateResultAndSetChanged();
    }

    public Map<ResourceLocation, Integer> getPartsStored() {
        return this.remainingParts;
    }

    public void dropContents() {
        InventoryHelper.dropItems((ItemStackHandler)this.decorativeBlocks, (Level)this.f_58857_, (BlockPos)this.f_58858_);
        InventoryHelper.dropItems((ItemStackHandler)this.dyes, (Level)this.f_58857_, (BlockPos)this.f_58858_);
        InventoryHelper.dropItems((ItemStackHandler)this.storageBlock, (Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    private static boolean isTintedStorage(ItemStack storage) {
        return StorageBlockItem.getMainColorFromStack(storage).isPresent() || StorageBlockItem.getAccentColorFromStack(storage).isPresent();
    }

    private static boolean colorsTransparentOrSameAs(ItemStack storage, int mainColorToSet, int accentColorToSet) {
        return !(mainColorToSet != -1 && mainColorToSet != StorageBlockItem.getMainColorFromStack(storage).orElse(-1) || accentColorToSet != -1 && accentColorToSet != StorageBlockItem.getAccentColorFromStack(storage).orElse(-1));
    }

    static {
        ITEM_DECORATORS.put(stack -> stack.m_41720_() instanceof StorageBlockItem, STORAGE_DECORATOR);
        ITEM_DECORATORS.put(stack -> stack.m_41720_() instanceof PaintbrushItem, new IItemDecorator(){

            @Override
            public boolean consumesIngredientsOnCraft() {
                return false;
            }

            @Override
            public boolean supportsMaterials(ItemStack input) {
                return true;
            }

            @Override
            public boolean supportsTints(ItemStack input) {
                return true;
            }

            @Override
            public boolean supportsTopInnerTrim(ItemStack input) {
                return true;
            }

            @Override
            public ItemStack decorateWithMaterials(ItemStack input, Map<BarrelMaterial, ResourceLocation> materialsToApply) {
                BarrelBlockItem.compactMaterials(materialsToApply);
                if (DecorationTableBlockEntity.allMaterialsMatch(materialsToApply, BarrelBlockItem.getMaterials(input))) {
                    return ItemStack.f_41583_;
                }
                ItemStack result = input.m_255036_(1);
                PaintbrushItem.setBarrelMaterials(result, materialsToApply);
                return result;
            }

            @Override
            public TintDecorationResult decorateWithTints(ItemStack input, int mainColorToSet, int accentColorToSet) {
                if (mainColorToSet == -1 && accentColorToSet == -1 || mainColorToSet == PaintbrushItem.getMainColor(input) && accentColorToSet == PaintbrushItem.getAccentColor(input)) {
                    return TintDecorationResult.EMPTY;
                }
                ItemStack result = input.m_255036_(1);
                if (mainColorToSet != -1) {
                    PaintbrushItem.setMainColor(result, mainColorToSet);
                }
                if (accentColorToSet != -1) {
                    PaintbrushItem.setAccentColor(result, accentColorToSet);
                }
                return new TintDecorationResult(result, Collections.emptyMap());
            }

            @Override
            public List<ItemStack> getPreviewStackInputs(ItemStack input, boolean materialsInCraftingSlots) {
                if (materialsInCraftingSlots) {
                    return List.of(new ItemStack((ItemLike)ModBlocks.LIMITED_BARREL_3_ITEM.get()));
                }
                return List.of(new ItemStack((ItemLike)ModBlocks.LIMITED_BARREL_3_ITEM.get()), new ItemStack((ItemLike)ModBlocks.CHEST_ITEM.get()), new ItemStack((ItemLike)ModBlocks.SHULKER_BOX_ITEM.get()));
            }
        });
        ITEM_DECORATORS.put(stack -> stack.m_41720_() instanceof DyeableLeatherItem, new IItemDecorator(){

            @Override
            public boolean supportsMaterials(ItemStack input) {
                return false;
            }

            @Override
            public boolean supportsTints(ItemStack input) {
                return true;
            }

            @Override
            public boolean supportsTopInnerTrim(ItemStack input) {
                return false;
            }

            @Override
            public ItemStack decorateWithMaterials(ItemStack input, Map<BarrelMaterial, ResourceLocation> materialsToApply) {
                return ItemStack.f_41583_;
            }

            @Override
            public TintDecorationResult decorateWithTints(ItemStack input, int mainColorToSet, int accentColorToSet) {
                DyeableLeatherItem dyeableLeatherItem;
                Item item;
                if (mainColorToSet == -1 || !((item = input.m_41720_()) instanceof DyeableLeatherItem) || (dyeableLeatherItem = (DyeableLeatherItem)item).m_41121_(input) == mainColorToSet) {
                    return TintDecorationResult.EMPTY;
                }
                int currentColor = dyeableLeatherItem.m_41121_(input);
                ItemStack result = input.m_255036_(1);
                dyeableLeatherItem.m_41115_(result, mainColorToSet);
                return new TintDecorationResult(result, DecorationHelper.getDyePartsNeeded(mainColorToSet, -1, currentColor, -1, 24, 0));
            }
        });
    }

    public static interface IItemDecorator {
        default public boolean consumesIngredientsOnCraft() {
            return true;
        }

        public boolean supportsMaterials(ItemStack var1);

        public boolean supportsTints(ItemStack var1);

        public boolean supportsTopInnerTrim(ItemStack var1);

        public ItemStack decorateWithMaterials(ItemStack var1, Map<BarrelMaterial, ResourceLocation> var2);

        public TintDecorationResult decorateWithTints(ItemStack var1, int var2, int var3);

        default public List<ItemStack> getPreviewStackInputs(ItemStack input, boolean materialsInCraftingSlots) {
            return List.of(input);
        }
    }

    public record TintDecorationResult(ItemStack result, Map<TagKey<Item>, Integer> requiredDyeParts) {
        public static final TintDecorationResult EMPTY = new TintDecorationResult(ItemStack.f_41583_, Collections.emptyMap());
    }
}

