/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.belt;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class UniversalAttractorItem
extends WearableArtifactItem {
    public UniversalAttractorItem() {
        PlayerEvent.DROP_ITEM.register(this::onItemToss);
    }

    @Override
    public boolean hasNonCosmeticEffects() {
        return ModGameRules.UNIVERSAL_ATTRACTOR_ENABLED.get();
    }

    EventResult onItemToss(Player player, ItemEntity entity) {
        if (ModGameRules.UNIVERSAL_ATTRACTOR_ENABLED.get().booleanValue() && this.isEquippedBy((LivingEntity)player)) {
            this.addCooldown((LivingEntity)player, 100);
        }
        return EventResult.pass();
    }

    @Override
    public void wornTick(LivingEntity entity, ItemStack stack) {
        Player player;
        if (!ModGameRules.UNIVERSAL_ATTRACTOR_ENABLED.get().booleanValue() || !(entity instanceof Player) || (player = (Player)entity).m_5833_() || this.isOnCooldown(entity) || !UniversalAttractorItem.isActivated(stack)) {
            return;
        }
        Vec3 playerPos = player.m_20182_().m_82520_(0.0, 0.75, 0.0);
        int range = 5;
        List items = player.m_9236_().m_45976_(ItemEntity.class, new AABB(playerPos.f_82479_ - (double)range, playerPos.f_82480_ - (double)range, playerPos.f_82481_ - (double)range, playerPos.f_82479_ + (double)range, playerPos.f_82480_ + (double)range, playerPos.f_82481_ + (double)range));
        int amountPulled = 0;
        for (ItemEntity item : items) {
            if (!item.m_6084_() || item.m_32063_()) continue;
            if (amountPulled++ > 200) break;
            Vec3 motion = playerPos.m_82546_(item.m_20182_().m_82520_(0.0, (double)(item.m_20206_() / 2.0f), 0.0));
            if (Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82480_ * motion.f_82480_ + motion.f_82481_ * motion.f_82481_) > 1.0) {
                motion = motion.m_82541_();
            }
            item.m_20256_(motion.m_82490_(0.6));
        }
    }

    @Override
    public boolean makesPiglinsNeutral() {
        return true;
    }
}

