/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.api;

import com.google.common.base.Suppliers;
import it.crystalnest.cobweb.api.pack.DynamicDataPack;
import it.crystalnest.cobweb.api.pack.DynamicTagBuilder;
import it.crystalnest.cobweb.api.registry.CobwebRegister;
import it.crystalnest.cobweb.api.registry.CobwebRegistry;
import it.crystalnest.soul_fire_d.Constants;
import it.crystalnest.soul_fire_d.api.Fire;
import it.crystalnest.soul_fire_d.api.block.CustomCampfireBlock;
import it.crystalnest.soul_fire_d.api.block.CustomFireBlock;
import it.crystalnest.soul_fire_d.api.block.CustomLanternBlock;
import it.crystalnest.soul_fire_d.api.block.CustomTorchBlock;
import it.crystalnest.soul_fire_d.api.block.CustomWallTorchBlock;
import it.crystalnest.soul_fire_d.api.block.entity.CustomCampfireBlockEntity;
import it.crystalnest.soul_fire_d.api.block.entity.DynamicBlockEntityType;
import it.crystalnest.soul_fire_d.api.type.FireTypeChanger;
import it.crystalnest.soul_fire_d.api.type.FireTyped;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FireManager {
    public static final String FIRE_TYPE_TAG = "FireType";
    public static final ResourceLocation DEFAULT_FIRE_TYPE = new ResourceLocation("");
    public static final ResourceLocation SOUL_FIRE_TYPE = new ResourceLocation("soul");
    public static final Fire DEFAULT_FIRE = new Fire(DEFAULT_FIRE_TYPE, 15, 1.0f, false, true, Fire.Builder.DEFAULT_IN_FIRE_GETTER, Fire.Builder.DEFAULT_ON_FIRE_GETTER, Fire.Builder.DEFAULT_BEHAVIOR, Map.ofEntries(Map.entry(Fire.Component.SOURCE_BLOCK, BuiltInRegistries.f_256975_.m_7981_((Object)Blocks.f_50083_)), Map.entry(Fire.Component.CAMPFIRE_BLOCK, BuiltInRegistries.f_256975_.m_7981_((Object)Blocks.f_50683_)), Map.entry(Fire.Component.LANTERN_BLOCK, BuiltInRegistries.f_256975_.m_7981_((Object)Blocks.f_50681_)), Map.entry(Fire.Component.TORCH_BLOCK, BuiltInRegistries.f_256975_.m_7981_((Object)Blocks.f_50081_)), Map.entry(Fire.Component.WALL_TORCH_BLOCK, BuiltInRegistries.f_256975_.m_7981_((Object)Blocks.f_50082_)), Map.entry(Fire.Component.FLAME_PARTICLE, BuiltInRegistries.f_257034_.m_7981_((Object)ParticleTypes.f_123744_)), Map.entry(Fire.Component.FIRE_ASPECT_ENCHANTMENT, BuiltInRegistries.f_256876_.m_7981_((Object)Enchantments.f_44981_)), Map.entry(Fire.Component.FLAME_ENCHANTMENT, BuiltInRegistries.f_256876_.m_7981_((Object)Enchantments.f_44990_))));
    public static final Supplier<DynamicBlockEntityType<CustomCampfireBlockEntity>> CUSTOM_CAMPFIRE_ENTITY_TYPE = CobwebRegistry.of((ResourceKey)Registries.f_256922_, (String)"soul_fire_d").register("custom_campfire", () -> new DynamicBlockEntityType(CustomCampfireBlockEntity::new));
    private static final DynamicDataPack FIRE_SOURCE_TAGS = DynamicDataPack.named((ResourceLocation)new ResourceLocation("soul_fire_d", "fire_source_tags"));
    private static final DynamicDataPack CAMPFIRE_TAGS = DynamicDataPack.named((ResourceLocation)new ResourceLocation("soul_fire_d", "campfire_tags"));
    private static final ConcurrentHashMap<ResourceLocation, Fire> FIRES = new ConcurrentHashMap();

    private FireManager() {
    }

    public static Fire.Builder fireBuilder(String modId, String fireId) {
        return new Fire.Builder(modId, fireId);
    }

    public static Fire.Builder fireBuilder(ResourceLocation fireType) {
        return new Fire.Builder(fireType);
    }

    @Nullable
    public static synchronized Fire registerFire(Fire fire) {
        Fire previous = FIRES.computeIfAbsent(fire.getFireType(), key -> {
            Fire.Component.SOURCE_BLOCK.getOptionalValue(fire).ifPresent(block -> ((FireTypeChanger)block).setFireType((ResourceLocation)key));
            Fire.Component.CAMPFIRE_BLOCK.getOptionalValue(fire).ifPresent(block -> ((FireTypeChanger)block).setFireType((ResourceLocation)key));
            return fire;
        });
        if (previous != fire) {
            ResourceLocation fireType = fire.getFireType();
            Constants.LOGGER.error("Fire [{}] was already registered with the following value: {}", (Object)fireType, (Object)FireManager.getFire(fireType));
            return null;
        }
        return fire;
    }

    public static synchronized Map<ResourceLocation, @Nullable Fire> registerFires(Fire ... fires) {
        return FireManager.registerFires(List.of(fires));
    }

    public static synchronized Map<ResourceLocation, @Nullable Fire> registerFires(List<Fire> fires) {
        HashMap<ResourceLocation, @Nullable Fire> outcomes = new HashMap<ResourceLocation, Fire>();
        for (Fire fire : fires) {
            outcomes.put(fire.getFireType(), FireManager.registerFire(fire));
        }
        return outcomes;
    }

    @Nullable
    @ApiStatus.Internal
    public static synchronized Fire unregisterFire(ResourceLocation fireType) {
        return FIRES.remove(fireType);
    }

    public static Supplier<CustomFireBlock> registerFireSource(ResourceLocation fireType, TagKey<Block> base, MapColor color) {
        return FireManager.registerFireSource(fireType, type -> new CustomFireBlock((ResourceLocation)type, base, color));
    }

    public static Supplier<CustomFireBlock> registerFireSource(ResourceLocation fireType, TagKey<Block> base, BlockBehaviour.Properties properties) {
        return FireManager.registerFireSource(fireType, type -> new CustomFireBlock((ResourceLocation)type, base, properties));
    }

    public static <T extends CustomFireBlock> Supplier<T> registerFireSource(ResourceLocation fireType, Function<ResourceLocation, T> supplier) {
        com.google.common.base.Supplier source = Suppliers.memoize(() -> (CustomFireBlock)supplier.apply(fireType));
        FIRE_SOURCE_TAGS.add(new Supplier[]{() -> FireManager.lambda$registerFireSource$7((Supplier)source)});
        return CobwebRegistry.ofBlocks((String)fireType.m_135827_()).register(FireManager.getComponentPath(fireType, Fire.Component.SOURCE_BLOCK), (Supplier)source);
    }

    public static Supplier<CustomCampfireBlock> registerCampfire(ResourceLocation fireType, boolean spawnParticles) {
        return FireManager.registerCampfire(fireType, type -> new CustomCampfireBlock((ResourceLocation)type, spawnParticles));
    }

    public static Supplier<CustomCampfireBlock> registerCampfire(ResourceLocation fireType, boolean spawnParticles, BlockBehaviour.Properties properties) {
        return FireManager.registerCampfire(fireType, type -> new CustomCampfireBlock((ResourceLocation)type, spawnParticles, properties));
    }

    public static <T extends CustomCampfireBlock> Supplier<T> registerCampfire(ResourceLocation fireType, Function<ResourceLocation, T> supplier) {
        com.google.common.base.Supplier campfire = Suppliers.memoize(() -> (CustomCampfireBlock)supplier.apply(fireType));
        CAMPFIRE_TAGS.add(new Supplier[]{() -> FireManager.lambda$registerCampfire$11((Supplier)campfire)});
        return CobwebRegistry.ofBlocks((String)fireType.m_135827_()).register(FireManager.getComponentPath(fireType, Fire.Component.CAMPFIRE_BLOCK), (Supplier)campfire);
    }

    public static Supplier<BlockItem> registerCampfireItem(ResourceLocation fireType) {
        return FireManager.registerCampfireItem(fireType, campfire -> new BlockItem(campfire, new Item.Properties()));
    }

    public static <T extends BlockItem> Supplier<T> registerCampfireItem(ResourceLocation fireType, Function<Block, T> supplier) {
        return CobwebRegistry.ofItems((String)fireType.m_135827_()).register(FireManager.getComponentPath(fireType, Fire.Component.CAMPFIRE_ITEM), () -> (BlockItem)supplier.apply(FireManager.getRequiredComponent(fireType, Fire.Component.CAMPFIRE_BLOCK)));
    }

    public static Supplier<SimpleParticleType> registerParticle(ResourceLocation fireType) {
        return FireManager.registerParticle(fireType, () -> new SimpleParticleType(false));
    }

    public static <T extends ParticleType<?>> Supplier<T> registerParticle(ResourceLocation fireType, Supplier<T> supplier) {
        return CobwebRegistry.of((ResourceKey)Registries.f_256890_, (String)fireType.m_135827_()).register(FireManager.getComponentPath(fireType, Fire.Component.FLAME_PARTICLE), supplier);
    }

    public static Pair<Supplier<CustomTorchBlock>, Supplier<CustomWallTorchBlock>> registerTorch(ResourceLocation fireType) {
        return FireManager.registerTorch(fireType, CustomTorchBlock::new, CustomWallTorchBlock::new);
    }

    public static <T extends CustomTorchBlock, W extends CustomWallTorchBlock> Pair<Supplier<T>, Supplier<W>> registerTorch(ResourceLocation fireType, BiFunction<ResourceLocation, Supplier<? extends ParticleOptions>, T> torchSupplier, BiFunction<ResourceLocation, Supplier<? extends ParticleOptions>, W> wallTorchSupplier) {
        CobwebRegister blocks = CobwebRegistry.ofBlocks((String)fireType.m_135827_());
        return Pair.of((Object)blocks.register(FireManager.getComponentPath(fireType, Fire.Component.TORCH_BLOCK), () -> (CustomTorchBlock)torchSupplier.apply(fireType, () -> (ParticleOptions)FireManager.getRequiredComponent(fireType, Fire.Component.FLAME_PARTICLE))), (Object)blocks.register(FireManager.getComponentPath(fireType, Fire.Component.WALL_TORCH_BLOCK), () -> (CustomWallTorchBlock)wallTorchSupplier.apply(fireType, () -> (ParticleOptions)FireManager.getRequiredComponent(fireType, Fire.Component.FLAME_PARTICLE))));
    }

    public static Supplier<StandingAndWallBlockItem> registerTorchItem(ResourceLocation fireType) {
        return FireManager.registerTorchItem(fireType, (torch, wallTorch) -> new StandingAndWallBlockItem(torch, wallTorch, new Item.Properties(), Direction.DOWN));
    }

    public static <T extends StandingAndWallBlockItem> Supplier<T> registerTorchItem(ResourceLocation fireType, BiFunction<Block, Block, T> supplier) {
        return CobwebRegistry.ofItems((String)fireType.m_135827_()).register(FireManager.getComponentPath(fireType, Fire.Component.TORCH_ITEM), () -> (StandingAndWallBlockItem)supplier.apply(FireManager.getRequiredComponent(fireType, Fire.Component.TORCH_BLOCK), FireManager.getRequiredComponent(fireType, Fire.Component.WALL_TORCH_BLOCK)));
    }

    public static Supplier<CustomLanternBlock> registerLantern(ResourceLocation fireType) {
        return FireManager.registerLantern(fireType, CustomLanternBlock::new);
    }

    public static <T extends CustomLanternBlock> Supplier<T> registerLantern(ResourceLocation fireType, Function<ResourceLocation, T> supplier) {
        return CobwebRegistry.ofBlocks((String)fireType.m_135827_()).register(FireManager.getComponentPath(fireType, Fire.Component.LANTERN_BLOCK), () -> (CustomLanternBlock)supplier.apply(fireType));
    }

    public static Supplier<BlockItem> registerLanternItem(ResourceLocation fireType) {
        return FireManager.registerLanternItem(fireType, lantern -> new BlockItem(lantern, new Item.Properties()));
    }

    public static <T extends BlockItem> Supplier<T> registerLanternItem(ResourceLocation fireType, Function<Block, T> supplier) {
        return CobwebRegistry.ofItems((String)fireType.m_135827_()).register(FireManager.getComponentPath(fireType, Fire.Component.LANTERN_ITEM), () -> (BlockItem)supplier.apply(FireManager.getRequiredComponent(fireType, Fire.Component.LANTERN_BLOCK)));
    }

    public static Fire getFire(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidFireId(fireId) ? FireManager.getFire(FireManager.fireType(modId, fireId)) : DEFAULT_FIRE;
    }

    public static Fire getFire(@Nullable ResourceLocation fireType) {
        return FIRES.getOrDefault(FireManager.ensure(fireType), DEFAULT_FIRE);
    }

    public static List<Fire> getFires() {
        return FIRES.values().stream().toList();
    }

    public static <T> T getProperty(ResourceLocation fireType, Function<Fire, T> getter) {
        return getter.apply(FireManager.getFire(fireType));
    }

    @Nullable
    public static ResourceLocation getComponentId(ResourceLocation fireType, Fire.Component<?, ?> component) {
        return FireManager.getFire(fireType).getComponent(component);
    }

    @Nullable
    public static <R, T extends R> T getComponent(ResourceLocation fireType, Fire.Component<R, T> component) {
        return component.getValue(FireManager.getComponentId(fireType, component));
    }

    @NotNull
    private static String getComponentPath(ResourceLocation fireType, Fire.Component<?, ?> component) {
        return Objects.requireNonNull(FireManager.getComponentId(fireType, component)).m_135815_();
    }

    @NotNull
    public static <R, T extends R> T getRequiredComponent(ResourceLocation fireType, Fire.Component<R, T> component) throws NullPointerException {
        return Objects.requireNonNull(component.getValue(FireManager.getComponentId(fireType, component)));
    }

    public static <T> List<T> getPropertyList(Function<Fire, T> getter) {
        return FIRES.values().stream().map(getter).toList();
    }

    public static List<ResourceLocation> getComponentIdList(Fire.Component<?, ?> component) {
        return FIRES.values().stream().map(fire -> fire.getComponent(component)).filter(Objects::nonNull).toList();
    }

    public static <R, T extends R> List<T> getComponentList(Fire.Component<R, T> component) {
        return FIRES.values().stream().map(component::getValue).filter(Objects::nonNull).toList();
    }

    public static boolean isValidType(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidFireId(fireId);
    }

    public static boolean isValidType(@Nullable ResourceLocation fireType) {
        return fireType != null && Strings.isNotBlank((String)fireType.m_135827_()) && Strings.isNotBlank((String)fireType.m_135815_());
    }

    public static boolean isRegisteredType(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidFireId(fireId) && FireManager.isRegisteredType(FireManager.fireType(modId, fireId));
    }

    public static boolean isRegisteredType(@Nullable ResourceLocation fireType) {
        return fireType != null && FIRES.containsKey(fireType);
    }

    public static boolean isValidFireId(@Nullable String fireId) {
        return Strings.isNotBlank((String)fireId) && ResourceLocation.m_135841_((String)fireId);
    }

    public static boolean isRegisteredFireId(@Nullable String fireId) {
        return FireManager.isValidFireId(fireId) && FIRES.keySet().stream().anyMatch(fireType -> fireType.m_135815_().equals(fireId));
    }

    public static boolean isValidModId(@Nullable String modId) {
        return Strings.isNotBlank((String)modId) && ResourceLocation.m_135843_((String)modId);
    }

    public static boolean isRegisteredModId(@Nullable String modId) {
        return FireManager.isValidModId(modId) && FIRES.keySet().stream().anyMatch(fireType -> fireType.m_135827_().equals(modId));
    }

    public static ResourceLocation sanitize(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidModId(fireId) ? FireManager.sanitize(FireManager.fireType(modId, fireId)) : DEFAULT_FIRE_TYPE;
    }

    public static ResourceLocation sanitize(@Nullable ResourceLocation fireType) {
        return FireManager.isValidType(fireType) ? fireType : DEFAULT_FIRE_TYPE;
    }

    public static ResourceLocation ensure(@Nullable String modId, @Nullable String fireId) {
        String trimmedModId = modId == null ? "" : modId.trim();
        String trimmedFireId = fireId == null ? "" : fireId.trim();
        return FireManager.isValidModId(trimmedModId) && FireManager.isValidFireId(trimmedFireId) ? FireManager.ensure(new ResourceLocation(trimmedModId, trimmedFireId)) : DEFAULT_FIRE_TYPE;
    }

    public static ResourceLocation ensure(@Nullable ResourceLocation fireType) {
        return FireManager.isRegisteredType(fireType) ? fireType : DEFAULT_FIRE_TYPE;
    }

    public static List<ResourceLocation> getFireTypes() {
        return FIRES.keySet().stream().toList();
    }

    public static List<String> getFireIds() {
        return FIRES.keySet().stream().map(ResourceLocation::m_135815_).toList();
    }

    public static List<String> getModIds() {
        return FIRES.keySet().stream().map(ResourceLocation::m_135827_).toList();
    }

    public static DamageSource getInFireDamageSourceFor(Entity entity, ResourceLocation fireType) {
        return FireManager.getFire(fireType).getInFire(entity);
    }

    public static DamageSource getOnFireDamageSourceFor(Entity entity, ResourceLocation fireType) {
        return FireManager.getFire(fireType).getOnFire(entity);
    }

    public static void setOnFire(Entity entity, int seconds, ResourceLocation fireType) {
        FireManager.setOnFire(entity, seconds, fireType, Entity::m_20254_);
    }

    @ApiStatus.Internal
    public static void setOnFire(Entity entity, int seconds, ResourceLocation fireType, BiConsumer<Entity, Integer> setOnFireFunction) {
        setOnFireFunction.accept(entity, seconds);
        ((FireTypeChanger)entity).setFireType(FireManager.ensure(fireType));
    }

    public static boolean damageInFire(Entity entity, ResourceLocation fireType) {
        return FireManager.damageInFire(entity, fireType, (TriFunction<Entity, DamageSource, Float, Boolean>)((TriFunction)Entity::m_6469_));
    }

    @ApiStatus.Internal
    public static boolean damageInFire(Entity entity, ResourceLocation fireType, TriFunction<Entity, DamageSource, Float, Boolean> hurtFunction) {
        ((FireTypeChanger)entity).setFireType(FireManager.ensure(fireType));
        return FireManager.harmOrHeal(entity, FireManager.getInFireDamageSourceFor(entity, fireType), FireManager.getProperty(fireType, Fire::getDamage).floatValue(), FireManager.getProperty(fireType, Fire::invertHealAndHarm), hurtFunction);
    }

    public static boolean damageOnFire(Entity entity, ResourceLocation fireType) {
        return FireManager.damageOnFire(entity, fireType, (TriFunction<Entity, DamageSource, Float, Boolean>)((TriFunction)Entity::m_6469_));
    }

    @ApiStatus.Internal
    public static boolean damageOnFire(Entity entity, ResourceLocation fireType, TriFunction<Entity, DamageSource, Float, Boolean> hurtFunction) {
        ((FireTypeChanger)entity).setFireType(FireManager.ensure(fireType));
        return FireManager.harmOrHeal(entity, FireManager.getOnFireDamageSourceFor(entity, fireType), FireManager.getProperty(fireType, Fire::getDamage).floatValue(), FireManager.getProperty(fireType, Fire::invertHealAndHarm), hurtFunction);
    }

    private static boolean harmOrHeal(Entity entity, DamageSource damageSource, float damage, boolean invertHealAndHarm, TriFunction<Entity, DamageSource, Float, Boolean> hurtFunction) {
        Predicate behavior = FireManager.getProperty(((FireTyped)entity).getFireType(), Fire::getBehavior);
        if (behavior.test(entity) && Float.compare(damage, 0.0f) != 0) {
            if (damage > 0.0f) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (livingEntity.m_21222_() && invertHealAndHarm) {
                        livingEntity.m_5634_(damage);
                        return false;
                    }
                    return (Boolean)hurtFunction.apply((Object)livingEntity, (Object)damageSource, (Object)Float.valueOf(damage));
                }
                return (Boolean)hurtFunction.apply((Object)entity, (Object)damageSource, (Object)Float.valueOf(damage));
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity.m_21222_() && invertHealAndHarm) {
                    return (Boolean)hurtFunction.apply((Object)livingEntity, (Object)damageSource, (Object)Float.valueOf(-damage));
                }
                livingEntity.m_5634_(-damage);
                return false;
            }
        }
        return false;
    }

    public static void writeTag(CompoundTag tag, @Nullable ResourceLocation fireType) {
        tag.m_128359_(FIRE_TYPE_TAG, FireManager.ensure(fireType).toString());
    }

    public static ResourceLocation readTag(CompoundTag tag) {
        return FireManager.ensure(ResourceLocation.m_135820_((String)tag.m_128461_(FIRE_TYPE_TAG)));
    }

    private static ResourceLocation fireType(@Nullable String modId, @Nullable String fireId) {
        return new ResourceLocation(Objects.requireNonNull(modId), Objects.requireNonNull(fireId));
    }

    private static /* synthetic */ DynamicTagBuilder lambda$registerCampfire$11(Supplier campfire) {
        return DynamicTagBuilder.of((ResourceKey)Registries.f_256747_, (TagKey[])new TagKey[]{BlockTags.f_13087_}).addElement((Object)((Block)campfire.get()));
    }

    private static /* synthetic */ DynamicTagBuilder lambda$registerFireSource$7(Supplier source) {
        return DynamicTagBuilder.of((ResourceKey)Registries.f_256747_, (TagKey[])new TagKey[]{BlockTags.f_13076_}).addElement((Object)((Block)source.get()));
    }

    static {
        FIRE_SOURCE_TAGS.register();
        CAMPFIRE_TAGS.register();
    }
}

