/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.api.block;

import it.crystalnest.soul_fire_d.api.Fire;
import it.crystalnest.soul_fire_d.api.FireManager;
import it.crystalnest.soul_fire_d.api.block.entity.CustomCampfireBlockEntity;
import it.crystalnest.soul_fire_d.api.block.entity.DynamicBlockEntityType;
import it.crystalnest.soul_fire_d.api.type.FireTyped;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomCampfireBlock
extends CampfireBlock
implements FireTyped {
    private final ResourceLocation fireType;

    public CustomCampfireBlock(ResourceLocation fireType, boolean spawnParticles) {
        this(fireType, spawnParticles, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283819_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60955_().m_278183_());
    }

    public CustomCampfireBlock(ResourceLocation fireType, boolean spawnParticles, BlockBehaviour.Properties properties) {
        super(spawnParticles, Math.round(FireManager.getProperty(fireType, Fire::getDamage).floatValue()), properties.m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? FireManager.getProperty(fireType, Fire::getLight) : 0));
        this.fireType = fireType;
    }

    protected DynamicBlockEntityType<CustomCampfireBlockEntity> getBlockEntityType() {
        return FireManager.CUSTOM_CAMPFIRE_ENTITY_TYPE.get();
    }

    protected BlockEntityTicker<CampfireBlockEntity> particleTick() {
        return CampfireBlockEntity::m_155318_;
    }

    protected BlockEntityTicker<CampfireBlockEntity> cookTick() {
        return CampfireBlockEntity::m_155306_;
    }

    protected BlockEntityTicker<CampfireBlockEntity> cooldownTick() {
        return CampfireBlockEntity::m_155313_;
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CustomCampfireBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        DynamicBlockEntityType<CustomCampfireBlockEntity> customBlockEntityType = this.getBlockEntityType();
        if (level.f_46443_) {
            return (Boolean)state.m_61143_((Property)f_51227_) != false ? CustomCampfireBlock.m_152132_(blockEntityType, customBlockEntityType, this.particleTick()) : null;
        }
        return (Boolean)state.m_61143_((Property)f_51227_) != false ? CustomCampfireBlock.m_152132_(blockEntityType, customBlockEntityType, this.cookTick()) : CustomCampfireBlock.m_152132_(blockEntityType, customBlockEntityType, this.cooldownTick());
    }

    @Override
    public ResourceLocation getFireType() {
        return this.fireType;
    }
}

