/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.api.block;

import it.crystalnest.soul_fire_d.api.Fire;
import it.crystalnest.soul_fire_d.api.FireManager;
import it.crystalnest.soul_fire_d.api.type.FireTyped;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;

public class CustomFireBlock
extends BaseFireBlock
implements FireTyped {
    public static final int MAX_AGE = 15;
    public static final IntegerProperty AGE = FireBlock.f_53408_;
    private final ResourceLocation fireType;
    private final TagKey<Block> base;

    public CustomFireBlock(ResourceLocation fireType, TagKey<Block> base, MapColor color) {
        this(fireType, base, BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280170_().m_60910_().m_60966_().m_60918_(SoundType.f_56745_).m_278166_(PushReaction.DESTROY));
    }

    public CustomFireBlock(ResourceLocation fireType, TagKey<Block> base, BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> FireManager.getProperty(fireType, Fire::getLight)), FireManager.getProperty(fireType, Fire::getDamage).floatValue());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
        this.fireType = fireType;
        this.base = base;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState state2, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos pos2) {
        return this.m_7898_(state, (LevelReader)level, pos) ? this.getStateWithAge(level, pos, (Integer)state.m_61143_((Property)AGE)) : Blocks.f_50016_.m_49966_();
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return this.canSurvive(level.m_8055_(pos.m_7495_()));
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        super.m_213897_(state, level, pos, rand);
        this.scheduleTick((Level)level, pos);
        if (level.m_46469_().m_46207_(GameRules.f_46131_)) {
            int age = (Integer)state.m_61143_((Property)AGE);
            if (!state.m_60710_((LevelReader)level, pos) || FireManager.getProperty(this.getFireType(), Fire::canRainDouse).booleanValue() && !level.m_8055_(pos.m_7495_()).m_204336_(level.m_6042_().f_63836_()) && level.m_46471_() && level.m_46758_(pos) && (double)rand.m_188501_() < 0.2 + (double)age * 0.03) {
                level.m_7471_(pos, false);
            } else if (age < 15 && rand.m_188503_(2) == 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 4);
            }
        }
    }

    protected boolean m_7599_(@NotNull BlockState state) {
        return true;
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState initial, boolean updateFlags) {
        super.m_6807_(state, level, pos, initial, updateFlags);
        this.scheduleTick(level, pos);
    }

    @Override
    public ResourceLocation getFireType() {
        return this.fireType;
    }

    public boolean canSurvive(BlockState state) {
        return state.m_204336_(this.base);
    }

    protected BlockState getStateWithAge(LevelAccessor level, BlockPos pos, int age) {
        BlockState state = CustomFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos);
        return state.m_61138_((Property)AGE) ? (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age)) : state;
    }

    protected void scheduleTick(Level level, BlockPos pos) {
        level.m_186460_(pos, (Block)this, 30 + level.f_46441_.m_188503_(10));
    }
}

