/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dan200.computercraft.shared.command.CommandUtils;
import dan200.computercraft.shared.command.Exceptions;
import dan200.computercraft.shared.command.arguments.ArgumentParserUtils;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public record ComputerSelector(String selector, OptionalInt instanceId, @Nullable UUID instanceUuid, OptionalInt computerId, @Nullable String label, @Nullable ComputerFamily family, @Nullable AABB bounds, // Could not load outer class - annotation placement on inner may be incorrect
 @Nullable MinMaxBounds.Doubles range) {
    private static final ComputerSelector all = new ComputerSelector("@c[]", OptionalInt.empty(), null, OptionalInt.empty(), null, null, null, null);
    private static final UuidArgument uuidArgument = UuidArgument.m_113850_();
    private static final Map<String, Option> options;

    public static ComputerSelector all() {
        return all;
    }

    public Stream<ServerComputer> find(CommandSourceStack source) {
        ServerContext context = ServerContext.get(source.m_81377_());
        if (this.instanceId().isPresent()) {
            ServerComputer computer = context.registry().get(this.instanceId().getAsInt());
            return computer != null && this.matches(source, computer) ? Stream.of(computer) : Stream.of(new ServerComputer[0]);
        }
        if (this.instanceUuid() != null) {
            ServerComputer computer = context.registry().get(this.instanceUuid());
            return computer != null && this.matches(source, computer) ? Stream.of(computer) : Stream.of(new ServerComputer[0]);
        }
        return context.registry().getComputers().stream().filter(c -> this.matches(source, (ServerComputer)c));
    }

    public ServerComputer findOne(CommandSourceStack source) throws CommandSyntaxException {
        List<ServerComputer> computers = this.find(source).toList();
        if (computers.isEmpty()) {
            throw Exceptions.COMPUTER_ARG_NONE.create((Object)this.selector);
        }
        if (computers.size() == 1) {
            return computers.iterator().next();
        }
        MutableComponent builder = MutableComponent.m_237204_((ComponentContents)ComponentContents.f_237124_);
        boolean first = true;
        for (ServerComputer computer : computers) {
            if (first) {
                first = false;
            } else {
                builder.m_130946_(", ");
            }
            builder.m_7220_(ChatHelpers.makeComputerDumpCommand(computer));
        }
        throw Exceptions.COMPUTER_ARG_MANY.create((Object)this.selector, (Object)builder);
    }

    public boolean matches(CommandSourceStack source, ServerComputer computer) {
        return !(!this.instanceId().isEmpty() && computer.getInstanceID() != this.instanceId().getAsInt() || this.instanceUuid() != null && !computer.getInstanceUUID().equals(this.instanceUuid()) || !this.computerId().isEmpty() && computer.getID() != this.computerId().getAsInt() || this.label != null && !Objects.equals(computer.getLabel(), this.label) || this.family != null && computer.getFamily() != this.family || this.bounds != null && (source.m_81372_() != computer.getLevel() || !this.bounds.m_82390_(Vec3.m_82512_((Vec3i)computer.getPosition()))) || this.range != null && (source.m_81372_() != computer.getLevel() || !this.range.m_154812_(source.m_81371_().m_82557_(Vec3.m_82512_((Vec3i)computer.getPosition())))));
    }

    public static ComputerSelector parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        Builder builder = new Builder();
        if (ArgumentParserUtils.consume(reader, "@c[")) {
            ComputerSelector.parseSelector(builder, reader);
        } else {
            char kind = reader.peek();
            if (kind == '@') {
                reader.skip();
                builder.label = reader.readString();
            } else if (kind == '~') {
                reader.skip();
                builder.family = ComputerSelector.parseFamily(reader);
            } else if (kind == '#') {
                reader.skip();
                builder.computerId = OptionalInt.of(reader.readInt());
            } else {
                builder.instanceId = OptionalInt.of(reader.readInt());
            }
        }
        String selector = reader.getString().substring(start, reader.getCursor());
        return new ComputerSelector(selector, builder.instanceId, builder.instanceUuid, builder.computerId, builder.label, builder.family, builder.bounds, builder.range);
    }

    private static void parseSelector(Builder builder, StringReader reader) throws CommandSyntaxException {
        block3: {
            HashSet<Option> seenOptions = new HashSet<Option>();
            do {
                reader.skipWhitespace();
                if (!reader.canRead()) {
                    throw Exceptions.ERROR_EXPECTED_END_OF_OPTIONS.createWithContext((ImmutableStringReader)reader);
                }
                if (ArgumentParserUtils.consume(reader, ']')) break block3;
                Option option = ComputerSelector.parseOption(reader, seenOptions);
                reader.skipWhitespace();
                if (!ArgumentParserUtils.consume(reader, '=')) {
                    throw Exceptions.ERROR_EXPECTED_OPTION_VALUE.createWithContext((ImmutableStringReader)reader, (Object)option.name());
                }
                reader.skipWhitespace();
                option.parser.parse(reader, builder);
                reader.skipWhitespace();
                if (ArgumentParserUtils.consume(reader, ']')) break block3;
            } while (ArgumentParserUtils.consume(reader, ','));
            throw Exceptions.ERROR_EXPECTED_END_OF_OPTIONS.createWithContext((ImmutableStringReader)reader);
        }
    }

    private static Option parseOption(StringReader reader, Set<Option> seen) throws CommandSyntaxException {
        int start = reader.getCursor();
        String name = reader.readUnquotedString();
        Option option = options.get(name);
        if (option == null) {
            reader.setCursor(start);
            throw Exceptions.ERROR_UNKNOWN_OPTION.createWithContext((ImmutableStringReader)reader, (Object)name);
        }
        if (!seen.add(option)) {
            throw Exceptions.ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)reader, (Object)name);
        }
        return option;
    }

    private static ComputerFamily parseFamily(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        String name = reader.readUnquotedString();
        ComputerFamily family = Arrays.stream(ComputerFamily.values()).filter(x -> x.name().equalsIgnoreCase(name)).findFirst().orElse(null);
        if (family == null) {
            reader.setCursor(start);
            throw Exceptions.UNKNOWN_FAMILY.createWithContext((ImmutableStringReader)reader, (Object)name);
        }
        return family;
    }

    public static CompletableFuture<Suggestions> suggest(CommandContext<?> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining();
        if (remaining.startsWith("@")) {
            StringReader reader = new StringReader(builder.getInput());
            reader.setCursor(builder.getStart());
            return ComputerSelector.suggestSelector(context, reader);
        }
        if (remaining.startsWith("#")) {
            return ComputerSelector.suggestComputers(c -> "#" + c.getID()).suggest(context, builder);
        }
        return ComputerSelector.suggestComputers(c -> Integer.toString(c.getInstanceID())).suggest(context, builder);
    }

    private static CompletableFuture<Suggestions> suggestSelector(CommandContext<?> context, StringReader reader) {
        block8: {
            HashSet<Option> seenOptions = new HashSet<Option>();
            Builder builder = new Builder();
            if (!ArgumentParserUtils.consume(reader, "@c[")) {
                return ComputerSelector.suggestions(reader).suggest("@c[").buildFuture();
            }
            do {
                Option option;
                reader.skipWhitespace();
                if (!reader.canRead()) {
                    return ComputerSelector.suggestOptions(reader);
                }
                if (ArgumentParserUtils.consume(reader, ']')) break block8;
                try {
                    option = ComputerSelector.parseOption(reader, seenOptions);
                }
                catch (CommandSyntaxException e) {
                    return ComputerSelector.suggestOptions(reader);
                }
                reader.skipWhitespace();
                if (!ArgumentParserUtils.consume(reader, '=')) {
                    return ComputerSelector.suggestions(reader).suggest("=").buildFuture();
                }
                reader.skipWhitespace();
                try {
                    option.parser.parse(reader, builder);
                }
                catch (CommandSyntaxException e) {
                    return option.suggest.suggest(context, ComputerSelector.suggestions(reader));
                }
                reader.skipWhitespace();
                if (ArgumentParserUtils.consume(reader, ']')) break block8;
            } while (ArgumentParserUtils.consume(reader, ','));
            return ComputerSelector.suggestions(reader).suggest(",").buildFuture();
        }
        return Suggestions.empty();
    }

    private static CompletableFuture<Suggestions> suggestOptions(StringReader reader) {
        return SharedSuggestionProvider.m_165916_(ComputerSelector.options().values(), (SuggestionsBuilder)ComputerSelector.suggestions(reader), Option::name, Option::tooltip);
    }

    private static SuggestionsBuilder suggestions(StringReader reader) {
        return new SuggestionsBuilder(reader.getString(), reader.getCursor());
    }

    public static Map<String, Option> options() {
        return options;
    }

    private static SuggestionProvider suggestComputers(Function<ServerComputer, String> renderer) {
        return (anyContext, builder) -> CommandUtils.suggestOnServer(anyContext, context -> {
            String remaining = builder.getRemaining();
            for (ServerComputer computer : ServerContext.get(((CommandSourceStack)context.getSource()).m_81377_()).registry().getComputers()) {
                String converted = (String)renderer.apply(computer);
                if (converted == null || !converted.startsWith(remaining)) continue;
                builder.suggest(converted);
            }
            return builder.buildFuture();
        });
    }

    static {
        Option[] optionList = new Option[]{new Option("instance", (reader, builder) -> {
            builder.instanceUuid = uuidArgument.parse(reader);
        }, ComputerSelector.suggestComputers(c -> c.getInstanceUUID().toString())), new Option("id", (reader, builder) -> {
            builder.computerId = OptionalInt.of(reader.readInt());
        }, ComputerSelector.suggestComputers(c -> Integer.toString(c.getID()))), new Option("label", (reader, builder) -> {
            builder.label = reader.readQuotedString();
        }, ComputerSelector.suggestComputers(ServerComputer::getLabel)), new Option("family", (reader, builder) -> {
            builder.family = ComputerSelector.parseFamily(reader);
        }, (source, builder) -> SharedSuggestionProvider.m_82981_(Arrays.stream(ComputerFamily.values()).map(x -> x.name().toLowerCase(Locale.ROOT)), (SuggestionsBuilder)builder)), new Option("distance", (reader, builder) -> {
            builder.range = MinMaxBounds.Doubles.m_154793_((StringReader)reader);
        }, (source, builder) -> Suggestions.empty())};
        options = Arrays.stream(optionList).collect(Collectors.toUnmodifiableMap(Option::name, x -> x));
    }

    private static final class Builder {
        private OptionalInt instanceId = OptionalInt.empty();
        private @Nullable UUID instanceUuid = null;
        private OptionalInt computerId = OptionalInt.empty();
        private @Nullable String label;
        private @Nullable ComputerFamily family;
        private @Nullable AABB bounds;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable MinMaxBounds.Doubles range;

        private Builder() {
        }
    }

    public static final class Option {
        private final String name;
        private final Parser parser;
        private final SuggestionProvider suggest;
        private final String translationKey;
        private final Message tooltip;

        Option(String name, Parser parser, SuggestionProvider suggest) {
            this.name = name;
            this.parser = parser;
            this.suggest = suggest;
            this.translationKey = "argument.computercraft.computer." + name;
            this.tooltip = Component.m_237115_((String)this.translationKey);
        }

        public String name() {
            return this.name;
        }

        public Message tooltip() {
            return this.tooltip;
        }

        public String translationKey() {
            return this.translationKey;
        }
    }

    private static interface Parser {
        public void parse(StringReader var1, Builder var2) throws CommandSyntaxException;
    }

    private static interface SuggestionProvider {
        public CompletableFuture<Suggestions> suggest(CommandContext<?> var1, SuggestionsBuilder var2);
    }
}

