/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.ReflectionUtils;

public class ReachEntityAttributesCompatibility {
    public static final boolean LOADED = ModLoaderUtils.isModLoaded("reach-entity-attributes");
    public static final ReachEntityAttributesCompatibility INSTANCE = new ReachEntityAttributesCompatibility();
    private final Optional<Class<?>> mainClass;
    private final Optional<Method> getReachDistance;
    private final Optional<Method> getAttackRange;
    private final Optional<Method> getSquaredReachDistance;
    private final Optional<Method> getSquaredAttackRange;
    private boolean enabled = LOADED;

    private ReachEntityAttributesCompatibility() {
        if (this.enabled) {
            this.mainClass = ReflectionUtils.getClass("com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes");
            this.getReachDistance = ReflectionUtils.getMethod(this.mainClass, "getReachDistance", LivingEntity.class, Double.TYPE);
            this.getAttackRange = ReflectionUtils.getMethod(this.mainClass, "getAttackRange", LivingEntity.class, Double.TYPE);
            this.getSquaredReachDistance = ReflectionUtils.getMethod(this.mainClass, "getSquaredReachDistance", LivingEntity.class, Double.TYPE);
            this.getSquaredAttackRange = ReflectionUtils.getMethod(this.mainClass, "getSquaredAttackRange", LivingEntity.class, Double.TYPE);
        } else {
            this.mainClass = Optional.empty();
            this.getReachDistance = Optional.empty();
            this.getAttackRange = Optional.empty();
            this.getSquaredReachDistance = Optional.empty();
            this.getSquaredAttackRange = Optional.empty();
        }
    }

    public double getReachDistance(LivingEntity entity, double baseValue) {
        return this.getReachDistance(this.getReachDistance, entity, baseValue);
    }

    public double getSquaredReachDistance(LivingEntity entity, double baseValue) {
        return this.getReachDistance(this.getSquaredReachDistance, entity, baseValue);
    }

    public double getAttackRange(LivingEntity entity, double baseValue) {
        return this.getReachDistance(this.getAttackRange, entity, baseValue);
    }

    public double getSquaredAttackRange(LivingEntity entity, double baseValue) {
        return this.getReachDistance(this.getSquaredAttackRange, entity, baseValue);
    }

    private double getReachDistance(Optional<Method> method, LivingEntity entity, double baseValue) {
        if (this.enabled) {
            return method.map(m -> {
                try {
                    return (double)((Double)m.invoke(null, entity, baseValue));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return null;
                }
            }).orElse(baseValue);
        }
        return baseValue;
    }
}

