/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.geo.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nukateam.geo.interfaces.DynamicGeoItem;
import com.nukateam.geo.render.ItemAnimator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.model.data.EntityModelData;
import mod.azure.azurelib.renderer.GeoObjectRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class DynamicGeoItemRenderer<Animator extends ItemAnimator>
extends GeoObjectRenderer<Animator> {
    private final Map<Pair<LivingEntity, ItemDisplayContext>, Animator> animatorsByTransform = new HashMap<Pair<LivingEntity, ItemDisplayContext>, Animator>();
    private BiFunction<ItemDisplayContext, DynamicGeoItemRenderer<Animator>, Animator> animatorFactory = null;
    private ItemStack currentStack;
    private ItemDisplayContext currentTransform;
    protected LivingEntity currentEntity;
    private LivingEntity buffEntity = null;

    public DynamicGeoItemRenderer(GeoModel<Animator> model) {
        super(model);
    }

    public DynamicGeoItemRenderer(GeoModel<Animator> model, BiFunction<ItemDisplayContext, DynamicGeoItemRenderer<Animator>, Animator> animatorFactory) {
        super(model);
        this.animatorFactory = animatorFactory;
    }

    public void defaultRender(PoseStack poseStack, Animator animatable, MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
        ((ItemAnimator)animatable).setStack(this.currentStack);
        super.defaultRender(poseStack, animatable, bufferSource, renderType, buffer, yaw, partialTick, packedLight);
    }

    public void actuallyRender(PoseStack poseStack, Animator animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        boolean shouldSit = false;
        float lerpBodyRot = 0.0f;
        float lerpHeadRot = 0.0f;
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!isReRender) {
            this.setupRender(animatable, isReRender, partialTick, shouldSit, netHeadYaw, limbSwingAmount, limbSwing);
        }
        poseStack.m_85837_(0.0, (double)0.01f, 0.0);
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public void render(LivingEntity entity, ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, @Nullable MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, int packedLight) {
        this.currentStack = stack;
        this.currentTransform = transformType;
        this.currentEntity = entity;
        if (this.buffEntity != null) {
            this.currentEntity = this.buffEntity;
            this.buffEntity = null;
        }
        super.render(poseStack, this.getAnimator(this.currentEntity, transformType, stack), bufferSource, renderType, buffer, packedLight);
    }

    public Animator getAnimator(LivingEntity entity, ItemDisplayContext transformType, ItemStack stack) {
        Pair key = Pair.of((Object)entity, (Object)transformType);
        if (!this.animatorsByTransform.containsKey(key)) {
            if (this.animatorFactory == null) {
                DynamicGeoItem dynamicItem = (DynamicGeoItem)stack.m_41720_();
                this.animatorFactory = dynamicItem.getAnimatorFactory();
            }
            this.animatorsByTransform.put((Pair<LivingEntity, ItemDisplayContext>)key, (ItemAnimator)this.animatorFactory.apply(transformType, this));
        }
        return (Animator)((ItemAnimator)this.animatorsByTransform.get(key));
    }

    public LivingEntity getRenderEntity() {
        return this.currentEntity;
    }

    public void setEntity(LivingEntity entity) {
        this.buffEntity = entity;
    }

    private void setupRender(Animator animatable, boolean isReRender, float partialTick, boolean shouldSit, float netHeadYaw, float limbSwingAmount, float limbSwing) {
        int headPitch = 0;
        boolean motionThreshold = false;
        Vec3 velocity = Vec3.f_82478_;
        float avgVelocity = (float)(Math.abs(velocity.f_82479_) + Math.abs(velocity.f_82481_)) / 2.0f;
        AnimationState animationState = new AnimationState(animatable, limbSwing, limbSwingAmount, partialTick, avgVelocity >= (float)motionThreshold && limbSwingAmount != 0.0f);
        long instanceId = this.getInstanceId((GeoAnimatable)animatable);
        animationState.setData(DataTickets.ITEM_RENDER_PERSPECTIVE, (Object)this.currentTransform);
        animationState.setData(DataTickets.ITEMSTACK, (Object)this.currentStack);
        animationState.setData(DataTickets.TICK, (Object)animatable.getTick(animatable));
        animationState.setData(DataTickets.ENTITY, (Object)this.currentEntity);
        animationState.setData(DataTickets.ENTITY_MODEL_DATA, (Object)new EntityModelData(shouldSit, false, -netHeadYaw, (float)(-headPitch)));
        GeoModel var31 = this.model;
        Objects.requireNonNull(animationState);
        var31.addAdditionalStateData(animatable, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
        this.model.handleAnimations(animatable, instanceId, animationState);
    }
}

