/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.geo.render;

import com.nukateam.geo.interfaces.IItemAnimator;
import com.nukateam.geo.interfaces.IResourceProvider;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public abstract class ItemAnimator
implements GeoEntity,
IItemAnimator,
IResourceProvider {
    protected final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    protected final ItemDisplayContext transformType;
    protected ItemStack itemStack;
    private final Lazy<String> name = Lazy.of(this::crateName);
    private final Lazy<String> namespace = Lazy.of(this::createNamespace);

    public ItemAnimator(ItemDisplayContext transformType) {
        this.transformType = transformType;
    }

    @Override
    public ItemStack getStack() {
        return this.itemStack;
    }

    @Override
    public void setStack(ItemStack stack) {
        this.itemStack = stack;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ItemDisplayContext getTransformType() {
        return this.transformType;
    }

    @Override
    public String getName() {
        return (String)this.name.get();
    }

    @Override
    public String getNamespace() {
        return (String)this.namespace.get();
    }

    private String crateName() {
        Item item = this.getStack().m_41720_();
        if (item instanceof IResourceProvider) {
            IResourceProvider provider = (IResourceProvider)item;
            return provider.getName();
        }
        ResourceLocation registryName = ItemAnimator.getRegistryKey(item);
        return ItemAnimator.getResourceName(registryName);
    }

    public static String getResourceName(ResourceLocation resourceLocation) {
        String path = resourceLocation.m_135815_();
        return FilenameUtils.removeExtension((String)FilenameUtils.getName((String)path));
    }

    private String createNamespace() {
        Item item = this.getStack().m_41720_();
        if (item instanceof IResourceProvider) {
            IResourceProvider provider = (IResourceProvider)item;
            return provider.getNamespace();
        }
        ResourceLocation registryName = ItemAnimator.getRegistryKey(item);
        return registryName.m_135827_();
    }

    @Nullable
    private static ResourceLocation getRegistryKey(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }
}

