/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.render.renderers.weapon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nukateam.geo.render.DynamicGeoItemRenderer;
import com.nukateam.geo.render.ItemAnimator;
import com.nukateam.ntgl.client.handlers.ClientTickHandler;
import com.nukateam.ntgl.client.render.GeoRenderUtils;
import com.nukateam.ntgl.client.render.layers.GlowingLayer;
import com.nukateam.ntgl.client.util.util.TransformUtils;
import com.nukateam.ntgl.common.util.helpers.compatibility.ChassisHelper;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.util.ClientUtils;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.Nullable;

public class ArmsRenderer<Animator extends ItemAnimator>
extends DynamicGeoItemRenderer<Animator> {
    public static final String RIGHT_ARM = "right_arm";
    public static final String LEFT_ARM = "left_arm";
    public static final String RIGHT_ARM_ANIM = "right_arm_anim";
    public static final String LEFT_ARM_ANIM = "left_arm_anim";
    protected MultiBufferSource bufferSource;
    protected boolean firstRightRender = true;
    protected boolean firstLeftRender = true;
    private ItemDisplayContext transformType;

    public ArmsRenderer(GeoModel<Animator> model) {
        super(model);
        this.addRenderLayer(new GlowingLayer(this));
        ClientTickHandler.addTicker((Object)this, this::tick);
    }

    protected void tick(TickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            // empty if block
        }
    }

    @Override
    public void render(LivingEntity entity, ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, @Nullable MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, int packedLight) {
        this.bufferSource = bufferSource;
        this.transformType = transformType;
        this.firstRightRender = true;
        this.firstLeftRender = true;
        this.currentEntity = entity;
        poseStack.m_85836_();
        super.render(entity, stack, transformType, poseStack, bufferSource, renderType, buffer, packedLight);
        poseStack.m_85849_();
    }

    public void renderRecursively(PoseStack poseStack, Animator animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        switch (bone.getName()) {
            case "left_arm": 
            case "right_arm": {
                bone.setHidden(true);
                bone.setChildrenHidden(false);
                this.renderArms(poseStack, bone, packedLight, packedOverlay);
                break;
            }
            case "left_arm_anim": 
            case "right_arm_anim": {
                if (!TransformUtils.isFirstPerson(this.transformType)) {
                    bone.setHidden(true);
                    break;
                }
                bone.setHidden(false);
            }
        }
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, this.bufferSource.m_6299_(renderType), isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    protected void renderArms(PoseStack poseStack, GeoBone bone, int packedLight, int packedOverlay) {
        boolean isLeftHand;
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == null) {
            return;
        }
        boolean isRightHand = this.transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        boolean bl = isLeftHand = this.transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
        if (bone.getName().equals(RIGHT_ARM)) {
            if (!this.firstRightRender) {
                return;
            }
            this.firstRightRender = false;
        }
        if (bone.getName().equals(LEFT_ARM)) {
            if (!this.firstLeftRender) {
                return;
            }
            this.firstLeftRender = false;
        }
        if (isRightHand || isLeftHand) {
            poseStack.m_85836_();
            RenderUtils.prepMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
            poseStack.m_85837_(0.01, -0.27, 0.05);
            poseStack.m_85841_(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
            if (ChassisHelper.isPlayerInChassis()) {
                if (isRightHand) {
                    if (bone.getName().equals(LEFT_ARM)) {
                        ChassisHelper.renderChassisHand(poseStack, isRightHand, HumanoidArm.LEFT, packedLight);
                    } else if (bone.getName().equals(RIGHT_ARM)) {
                        ChassisHelper.renderChassisHand(poseStack, isRightHand, HumanoidArm.RIGHT, packedLight);
                    }
                } else if (bone.getName().equals(LEFT_ARM)) {
                    ChassisHelper.renderChassisHand(poseStack, isRightHand, HumanoidArm.RIGHT, packedLight);
                } else if (bone.getName().equals(RIGHT_ARM)) {
                    ChassisHelper.renderChassisHand(poseStack, isRightHand, HumanoidArm.LEFT, packedLight);
                }
            } else {
                ResourceLocation playerSkin = ((LocalPlayer)ClientUtils.getClientPlayer()).m_108560_();
                VertexConsumer arm = this.bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)playerSkin));
                VertexConsumer sleeve = this.bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)playerSkin));
                if (isRightHand) {
                    if (bone.getName().equals(LEFT_ARM)) {
                        poseStack.m_85837_(-0.05, 0.0, 0.0);
                        GeoRenderUtils.renderLeftArm(poseStack, bone, packedLight, packedOverlay, arm, sleeve);
                    } else if (bone.getName().equals(RIGHT_ARM)) {
                        poseStack.m_85837_(0.025, 0.0, -0.01875);
                        GeoRenderUtils.renderRightArm(poseStack, bone, packedLight, packedOverlay, arm, sleeve);
                    }
                } else if (bone.getName().equals(LEFT_ARM)) {
                    poseStack.m_85837_(0.025, 0.0, -0.01875);
                    GeoRenderUtils.renderRightArm(poseStack, bone, packedLight, packedOverlay, arm, sleeve);
                } else if (bone.getName().equals(RIGHT_ARM)) {
                    poseStack.m_85837_(-0.05, 0.0, 0.0);
                    GeoRenderUtils.renderLeftArm(poseStack, bone, packedLight, packedOverlay, arm, sleeve);
                }
            }
            poseStack.m_85849_();
        }
    }
}

