/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.settings;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.nukateam.ntgl.Ntgl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import org.apache.commons.io.IOUtils;

public class GunOptions {
    private static GunOptions instance = null;
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private final File optionsFile;
    private double adsSensitivity = 0.75;
    private double gunVolume = 1.0;

    public static GunOptions getInstance() {
        if (instance == null) {
            instance = new GunOptions(Minecraft.m_91087_().f_91069_);
        }
        return instance;
    }

    protected GunOptions(File dataDir) {
        this.optionsFile = new File(dataDir, "cgs-options.txt");
        this.loadOptions();
    }

    public double getAdsSensitivity() {
        return this.adsSensitivity;
    }

    public double getGunVolume() {
        return this.gunVolume;
    }

    public void setAdsSensitivity(double adsSensitivity) {
        this.adsSensitivity = adsSensitivity;
    }

    public void setGunVolume(double gunVolume) {
        this.gunVolume = gunVolume;
    }

    public void saveOptions() {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.optionsFile), StandardCharsets.UTF_8));){
            writer.println("adsSensitivity:" + this.adsSensitivity);
            writer.println("gunVolume:" + this.gunVolume);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void loadOptions() {
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            List lines = IOUtils.readLines((InputStream)new FileInputStream(this.optionsFile), (Charset)Charsets.UTF_8);
            CompoundTag compound = new CompoundTag();
            for (String line : lines) {
                try {
                    Iterator iterator = COLON_SPLITTER.omitEmptyStrings().limit(2).split((CharSequence)line).iterator();
                    compound.m_128359_((String)iterator.next(), (String)iterator.next());
                }
                catch (Exception var10) {
                    Ntgl.LOGGER.warn("Skipping bad option: {}", (Object)line);
                }
            }
            for (String key : compound.m_128431_()) {
                String value = compound.m_128461_(key);
                try {
                    this.readOption(key, value);
                }
                catch (Exception e) {
                    Ntgl.LOGGER.warn("Skipping bad option: {}:{}", (Object)key, (Object)value);
                }
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error("Failed to load options", (Throwable)e);
        }
    }

    private void readOption(String key, String value) {
        switch (key) {
            case "adsSensitivity": {
                this.adsSensitivity = Double.parseDouble(value);
                break;
            }
            case "gunVolume": {
                this.gunVolume = Double.parseDouble(value);
            }
        }
    }
}

