/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.handler;

import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.common.foundation.item.interfaces.IThrowable;
import com.nukateam.ntgl.common.network.KeyAction;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessageGrenade;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl", value={Dist.CLIENT})
public class ClientGrenadeHandler {
    private static final Map<InteractionHand, Tracker> TRACKER_MAP = new HashMap<InteractionHand, Tracker>();

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.END) {
            InteractionHand hand = InteractionHand.MAIN_HAND;
            if (minecraft.f_91066_.f_92096_.m_90857_()) {
                ItemStack stack = minecraft.f_91074_.m_21120_(hand);
                if (stack.m_41720_() instanceof IThrowable && !TRACKER_MAP.containsKey(hand)) {
                    TRACKER_MAP.put(hand, new Tracker((LivingEntity)minecraft.f_91074_, hand));
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageGrenade(KeyAction.HOLD, hand));
                }
            } else if (TRACKER_MAP.containsKey(hand)) {
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageGrenade(KeyAction.RELEASE, hand));
                TRACKER_MAP.remove(hand);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onMouseClick(InputEvent.InteractionKeyMappingTriggered event) {
        ItemStack offhandItem;
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (event.isAttack()) {
            ItemStack heldItem = player.m_21205_();
            if (heldItem.m_41720_() instanceof IThrowable) {
                event.setCanceled(true);
                event.setSwingHand(false);
            }
        } else if (event.isUseItem() && (offhandItem = player.m_21206_()).m_41720_() instanceof IThrowable && GunModifierHelper.canRenderInOffhand((LivingEntity)player)) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    private static class Tracker {
        private final InteractionHand arm;
        private final ItemStack stack;
        private final IThrowable throwable;
        private final int maxPrepare;
        private final int maxThrow;
        private final int maxLife;
        private final LivingEntity entity;
        private int prepareTick = 0;
        private int throwTick = 0;
        private int lifeTick = 0;
        private boolean isPreparing = true;
        private boolean isThrowing = false;

        private Tracker(LivingEntity entity, InteractionHand arm) {
            this.arm = arm;
            this.entity = entity;
            this.stack = entity.m_21120_(arm);
            this.throwable = (IThrowable)this.stack.m_41720_();
            this.maxPrepare = this.throwable.getConfig().getGeneral().getPrepareTime();
            this.maxThrow = this.throwable.getConfig().getGeneral().getThrowTime();
            this.maxLife = this.throwable.getConfig().getProjectile().getLife();
            this.prepareTick = this.maxPrepare;
            this.throwTick = this.maxThrow;
            this.lifeTick = this.maxLife;
        }

        private void explode() {
            this.stop();
        }

        private void stop() {
            TRACKER_MAP.remove(this.arm);
        }

        private boolean isSameWeapon() {
            return !this.stack.m_41619_() && this.entity.m_21120_(this.arm) == this.stack;
        }
    }
}

