/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.handler;

import com.ibm.icu.impl.Pair;
import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.util.handler.AimingHandler;
import com.nukateam.ntgl.client.util.handler.RecoilHandler;
import com.nukateam.ntgl.client.util.handler.ShootingData;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.event.GunFireEvent;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessagePreFireSound;
import com.nukateam.ntgl.common.network.message.C2SMessageShoot;
import com.nukateam.ntgl.common.util.helpers.compatibility.PlayerReviveHelper;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ShootingHandler {
    private static ShootingHandler instance;
    public static float shootMsGap;
    private boolean shooting;
    private final HashMap<Pair<InteractionHand, LivingEntity>, Integer> entityShootGaps = new HashMap();
    private final Map<InteractionHand, ShootingData> shootingData = Map.of(InteractionHand.MAIN_HAND, new ShootingData(0, null), InteractionHand.OFF_HAND, new ShootingData(0, null));

    private ShootingHandler() {
    }

    public static ShootingHandler get() {
        if (instance == null) {
            instance = new ShootingHandler();
        }
        return instance;
    }

    public static boolean isInGame() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91265_() != null) {
            return false;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        if (!mc.f_91067_.m_91600_()) {
            return false;
        }
        return mc.m_91302_();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMouseClick(InputEvent.MouseButton event) {
        ItemStack heldItem;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        boolean isRightHand = event.getButton() == mc.f_91066_.f_92096_.getKey().m_84873_();
        boolean isLeftHand = event.getButton() == mc.f_91066_.f_92095_.getKey().m_84873_();
        ItemStack itemStack = heldItem = isRightHand ? player.m_21205_() : player.m_21206_();
        if (heldItem.m_41720_() instanceof WeaponItem) {
            if (event.getAction() == 1) {
                if (isRightHand) {
                    this.setupShootingData(heldItem, (Player)player, InteractionHand.MAIN_HAND);
                }
                if (isLeftHand) {
                    this.setupShootingData(heldItem, (Player)player, InteractionHand.OFF_HAND);
                }
            } else if (event.getAction() == 0) {
                if (isRightHand) {
                    this.resetShootingData(heldItem, (Player)player, InteractionHand.MAIN_HAND);
                }
                if (isLeftHand) {
                    this.resetShootingData(heldItem, (Player)player, InteractionHand.OFF_HAND);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMouseClick(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || PlayerReviveHelper.isBleeding((Player)player)) {
            return;
        }
        if (event.isAttack()) {
            ItemStack heldItem = player.m_21205_();
            if (heldItem.m_41720_() instanceof WeaponItem) {
                this.cancelSwing(event);
            }
        } else if (event.isUseItem()) {
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offhandItem = player.m_21206_();
            if (offhandItem.m_41720_() instanceof WeaponItem && GunModifierHelper.canRenderInOffhand((LivingEntity)player)) {
                this.cancelSwing(event);
                return;
            }
            if (mainHandItem.m_41720_() instanceof WeaponItem) {
                if (event.getHand() == InteractionHand.OFF_HAND) {
                    if (offhandItem.m_41720_() == Items.f_42740_ && GunModifierHelper.getGripType(new GunData(mainHandItem, (LivingEntity)player)).isOneHanded()) {
                        return;
                    }
                    this.cancelSwing(event);
                    return;
                }
                if (AimingHandler.get().isZooming() && AimingHandler.get().isLookingAtInteractableBlock()) {
                    this.cancelSwing(event);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPostClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!ShootingHandler.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || PlayerReviveHelper.isBleeding((Player)player)) {
            return;
        }
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offhandItem = player.m_21206_();
        if (mainHandItem.m_41720_() instanceof WeaponItem && ShootingHandler.isKeyAttackDown()) {
            this.handleAutoFire(player, mainHandItem, InteractionHand.MAIN_HAND);
        }
        if (offhandItem.m_41720_() instanceof WeaponItem && ShootingHandler.isUseKeyDown() && GunModifierHelper.canRenderInOffhand((LivingEntity)player)) {
            this.handleAutoFire(player, offhandItem, InteractionHand.OFF_HAND);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderTickLow(TickEvent.RenderTickEvent evt) {
        if (!evt.type.equals((Object)TickEvent.Type.RENDER) || evt.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (shootMsGap > 0.0f) {
            shootMsGap -= evt.renderTickTime * ShootingHandler.visualCooldownMultiplier();
        } else if (shootMsGap < -0.05f) {
            shootMsGap = 0.0f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void cancelSwing(InputEvent.InteractionKeyMappingTriggered event) {
        event.setSwingHand(false);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onHandleShooting(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            this.reduceGaps();
            if (!ShootingHandler.isInGame()) {
                return;
            }
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        }
    }

    public ShootingData getShootingData(InteractionHand arm) {
        return this.shootingData.get(arm);
    }

    public boolean isOnCooldown(LivingEntity entity, InteractionHand arm) {
        return this.getCooldown(entity, arm) > 0;
    }

    public float getCooldownPercent(LivingEntity entity, InteractionHand hand) {
        ItemStack heldItem = entity.m_21120_(hand);
        Item item = heldItem.m_41720_();
        if (item instanceof WeaponItem) {
            WeaponItem weaponItem = (WeaponItem)item;
            GunData data = new GunData(heldItem, entity);
            int rate = GunModifierHelper.getRate(data);
            int cooldown = this.getCooldown(entity, hand);
            return (float)cooldown / (float)rate;
        }
        return 0.0f;
    }

    public void setCooldown(LivingEntity entity, InteractionHand arm, int cooldown) {
        this.entityShootGaps.put((Pair<InteractionHand, LivingEntity>)Pair.of((Object)arm, (Object)entity), cooldown);
    }

    public int getCooldown(LivingEntity entity, InteractionHand arm) {
        return this.entityShootGaps.getOrDefault(Pair.of((Object)arm, (Object)entity), 0);
    }

    public boolean isShooting(LivingEntity entity, InteractionHand arm) {
        return this.getCooldown(entity, arm) > 0;
    }

    public static float calcShootTickGap(int rpm) {
        float shootTickGap = 60.0f / (float)rpm * 20.0f;
        return shootTickGap;
    }

    private static boolean isGun(ItemStack heldItem, LivingEntity entity) {
        return GunModifierHelper.getWeaponMode(new GunData(heldItem, entity)) == WeaponMode.GUN;
    }

    public void fire(LivingEntity shooter, ItemStack heldItem) {
        if (heldItem.m_41720_() instanceof WeaponItem && GunStateHelper.hasAmmo(heldItem) && ShootingHandler.isGun(heldItem, shooter) && !shooter.m_5833_()) {
            boolean isMainHand = shooter.m_21205_() == heldItem;
            InteractionHand hand = isMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            Integer shootGap = this.entityShootGaps.getOrDefault(Pair.of((Object)hand, (Object)shooter), 0);
            if (shootGap <= 0) {
                if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre(shooter, heldItem, hand))) {
                    return;
                }
                GunData gunData = new GunData(heldItem, shooter);
                int rpm = GunModifierHelper.getRate(gunData);
                shootGap = shootGap + rpm;
                this.entityShootGaps.put((Pair<InteractionHand, LivingEntity>)Pair.of((Object)hand, (Object)shooter), shootGap);
                shootMsGap = ShootingHandler.calcShootTickGap(rpm);
                RecoilHandler.get().lastRandPitch = RecoilHandler.get().lastRandPitch;
                RecoilHandler.get().lastRandYaw = RecoilHandler.get().lastRandYaw;
                try {
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShoot(shooter.m_19879_(), shooter.m_5675_(1.0f), shooter.m_5686_(1.0f), RecoilHandler.get().lastRandPitch, RecoilHandler.get().lastRandYaw, isMainHand));
                }
                catch (NullPointerException e) {
                    Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
                }
                MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post(shooter, heldItem, hand));
            }
        } else {
            return;
        }
    }

    private static boolean isKeyAttackDown() {
        return Minecraft.m_91087_().f_91066_.f_92096_.m_90857_();
    }

    private static boolean isUseKeyDown() {
        return Minecraft.m_91087_().f_91066_.f_92095_.m_90857_();
    }

    private void reduceGaps() {
        this.entityShootGaps.forEach((key, val) -> {
            if (val > 0) {
                Integer n = val;
                val = val - 1;
            }
            this.entityShootGaps.put((Pair<InteractionHand, LivingEntity>)key, (Integer)val);
        });
    }

    private void setupShootingData(ItemStack stack, Player player, InteractionHand arm) {
        if (!GunStateHelper.hasAmmo(stack)) {
            return;
        }
        ShootingData data = this.shootingData.get(arm);
        GunData gunData = new GunData(stack, (LivingEntity)player);
        data.fireTimer = GunModifierHelper.getFireDelay(gunData);
        data.gun = (WeaponItem)stack.m_41720_();
    }

    private void resetShootingData(ItemStack stack, Player player, InteractionHand arm) {
        ShootingData data = this.shootingData.get(arm);
        GunData gunData = new GunData(stack, (LivingEntity)player);
        if (data.fireTimer != 0 && !GunModifierHelper.needsFullCharge(gunData)) {
            this.fire((LivingEntity)Minecraft.m_91087_().f_91074_, stack);
        }
        data.fireTimer = 0;
        data.gun = null;
    }

    private void handleAutoFire(LocalPlayer player, ItemStack heldItem, InteractionHand arm) {
        int maxChargeTime;
        FireMode fireMode;
        GunData gunData;
        ShootingData data;
        KeyMapping key;
        block13: {
            block12: {
                Minecraft mc = Minecraft.m_91087_();
                key = arm == InteractionHand.MAIN_HAND ? mc.f_91066_.f_92096_ : mc.f_91066_.f_92095_;
                data = this.shootingData.get(arm);
                gunData = new GunData(heldItem, (LivingEntity)player);
                fireMode = GunStateHelper.getFireMode(gunData);
                maxChargeTime = GunModifierHelper.getFireDelay(gunData);
                Item item = heldItem.m_41720_();
                if (!(item instanceof WeaponItem)) break block12;
                WeaponItem weaponItem = (WeaponItem)item;
                if (ShootingHandler.isGun(heldItem, (LivingEntity)player)) break block13;
            }
            return;
        }
        if (maxChargeTime != 0) {
            boolean isOnCooldown = ShootingHandler.get().isOnCooldown((LivingEntity)player, arm);
            if (data.fireTimer > 0 && !isOnCooldown) {
                if (data.fireTimer == maxChargeTime - 2) {
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessagePreFireSound((Player)player));
                }
                --data.fireTimer;
            } else {
                this.fire((LivingEntity)player, heldItem);
                if (data.fireTimer == 0 && !GunModifierHelper.isOneTimeCharge(gunData)) {
                    this.setupShootingData(heldItem, (Player)player, arm);
                }
                if (maxChargeTime > 0 && fireMode != FireMode.AUTO) {
                    key.m_7249_(false);
                }
            }
        } else {
            this.fire((LivingEntity)player, heldItem);
            if (fireMode != FireMode.AUTO) {
                key.m_7249_(false);
            }
        }
    }

    private static float visualCooldownMultiplier() {
        int fps = Minecraft.m_91087_().m_260875_();
        if (fps < 11) {
            return 8.0f;
        }
        if (fps < 21) {
            return 6.25f;
        }
        if (fps < 31) {
            return 1.25f;
        }
        if (fps < 61) {
            return 0.95f;
        }
        if (fps < 121) {
            return 0.625f;
        }
        if (fps < 181) {
            return 0.425f;
        }
        if (fps < 201) {
            return 0.35f;
        }
        return 0.25f;
    }

    static {
        shootMsGap = 0.0f;
    }
}

