/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.util.IHeldAnimation;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OneHandedPose
implements IHeldAnimation {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHumanoidModelRotation(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart head, InteractionHand hand, float aimProgress) {
        boolean isNotOneHanded;
        boolean flip = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT;
        ItemStack stack = entity.m_21120_(InteractionHand.MAIN_HAND);
        boolean right = hand == InteractionHand.MAIN_HAND;
        boolean bl = isNotOneHanded = stack.m_41720_() instanceof WeaponItem && !GunModifierHelper.getGripType(new GunData(stack, entity)).isOneHanded();
        if (!right && isNotOneHanded) {
            return;
        }
        ModelPart arm = right ? rightArm : leftArm;
        IHeldAnimation.copyModelAngles(head, arm);
        arm.f_104203_ += (float)Math.toRadians(-70.0);
        if (entity.m_21211_().m_41720_() == Items.f_42740_) {
            arm.f_104203_ = (float)Math.toRadians(-30.0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyGeoModelRotation(LivingEntity entity, CoreGeoBone rightArm, CoreGeoBone leftArm, CoreGeoBone head, InteractionHand interactionHand) {
        try {
            boolean right = interactionHand == InteractionHand.MAIN_HAND;
            CoreGeoBone arm = right ? rightArm : leftArm;
            arm.setRotX(head.getRotX());
            arm.setRotY(head.getRotY());
            arm.setRotZ(head.getRotZ());
            arm.setRotX(head.getRotX() + 70.0f);
        }
        catch (Exception e) {
            Ntgl.LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void applyHeldItemTransforms(LivingEntity entity, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        int side = hand == InteractionHand.OFF_HAND ? 1 : -1;
        poseStack.m_85837_(0.45 * (double)side, -0.5, -1.2);
    }

    @Override
    public boolean applyOffhandTransforms(LivingEntity entity, HumanoidModel<LivingEntity> model, ItemStack stack, PoseStack poseStack, float partialTicks) {
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        if (entity.m_6047_()) {
            poseStack.m_85837_(-0.28125, -0.9375, -0.25);
        } else if (!entity.m_6844_(EquipmentSlot.LEGS).m_41619_()) {
            poseStack.m_85837_(-0.25, -0.8125, 0.0625);
        } else {
            poseStack.m_85837_(-0.21875, -0.8125, 0.0625);
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(75.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(Math.toDegrees(model.f_102813_.f_104203_) / 10.0)));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        return true;
    }

    @Override
    public boolean canApplySprintingAnimation() {
        return false;
    }

    @Override
    public boolean canRenderOffhandItem() {
        return true;
    }

    @Override
    public double getFallSwayZOffset() {
        return 0.5;
    }
}

