/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.data.config.AmmoConfig;
import com.nukateam.ntgl.common.data.config.AmmoData;
import com.nukateam.ntgl.common.data.config.ProjectileConfig;
import com.nukateam.ntgl.common.data.holders.ThrowMode;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.util.annotation.Ignored;
import com.nukateam.ntgl.common.util.annotation.Optional;
import com.nukateam.ntgl.common.util.util.GunJsonUtil;
import com.nukateam.ntgl.common.util.util.NbtUtils;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ThrowableConfig
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    public static final String EQUIP_TIME = "equipTime";
    public static final String PREPARE_TIME = "prepareTime";
    public static final String THROW_TIME = "throwTime";
    public static final String GENERAL = "General";
    public static final String AMMO_DATA = "AmmoData";
    public static final String SOUNDS = "Sounds";
    public static final String TEXTURES = "Textures";
    protected General general = new General();
    protected AmmoData ammoData = new AmmoData();
    protected HashMap<String, ResourceLocation> sounds = new HashMap();
    protected HashMap<String, ResourceLocation> textures = new HashMap();
    @Ignored
    protected HashMap<String, ResourceLocation> preparedTextures = new HashMap();

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Gun");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {});
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(GENERAL, (Tag)this.general.serializeNBT());
        tag.m_128365_(AMMO_DATA, (Tag)this.ammoData.serializeNBT());
        tag.m_128365_(SOUNDS, (Tag)NbtUtils.serializeStringMap(this.sounds));
        tag.m_128365_(TEXTURES, (Tag)NbtUtils.serializeStringMap(this.textures));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_(GENERAL, 10)) {
            this.general = General.create(tag.m_128469_(GENERAL));
        }
        if (tag.m_128425_(AMMO_DATA, 10)) {
            this.ammoData = AmmoData.create(tag.m_128469_(AMMO_DATA));
        }
        if (tag.m_128425_(SOUNDS, 10)) {
            this.sounds = this.deserializeSounds(tag.m_128469_(SOUNDS));
        }
        if (tag.m_128425_(TEXTURES, 10)) {
            this.textures = NbtUtils.deserializeRLMap(tag.m_128469_(TEXTURES));
        }
    }

    public JsonObject toJsonObject() {
        Gson gson = new Gson();
        JsonObject object = new JsonObject();
        object.add("projectile", (JsonElement)this.ammoData.toJsonObject());
        object.add("general", (JsonElement)this.general.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "sounds", gson.toJsonTree(this.sounds).getAsJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "textures", gson.toJsonTree(this.textures).getAsJsonObject());
        return object;
    }

    public ThrowableConfig copy() {
        ThrowableConfig gun = new ThrowableConfig();
        gun.general = this.general;
        gun.ammoData = this.ammoData;
        gun.sounds = (HashMap)this.sounds.clone();
        gun.textures = (HashMap)this.textures.clone();
        return gun;
    }

    public General getGeneral() {
        return this.general;
    }

    public ProjectileConfig getProjectile() {
        return this.ammoData.getProjectile();
    }

    public AmmoConfig getAmmo() {
        return this.ammoData.getAmmo();
    }

    public HashMap<String, ResourceLocation> getSoundsMap() {
        return this.sounds;
    }

    public Map<String, ResourceLocation> getTextures() {
        return this.preparedTextures;
    }

    private HashMap<String, ResourceLocation> deserializeSounds(CompoundTag tag) {
        HashMap<String, ResourceLocation> result = new HashMap<String, ResourceLocation>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            result.put(key, this.createSound(tag, key));
        }
        return result;
    }

    private ResourceLocation createSound(CompoundTag tag, String key) {
        String sound = tag.m_128461_(key);
        return sound.isEmpty() ? null : ResourceLocation.m_135820_((String)sound);
    }

    public static ThrowableConfig create(ResourceLocation id, CompoundTag tag) {
        ThrowableConfig gun = new ThrowableConfig();
        gun.deserializeNBT(tag);
        ThrowableConfig.prepareTextures(id.m_135815_(), gun);
        return gun;
    }

    public void onCreated(String id) {
        ThrowableConfig.prepareTextures(id, this);
    }

    private static void prepareTextures(String itemId, ThrowableConfig gun) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            CompletableFuture.runAsync(() -> gun.textures.forEach((variant, path) -> {
                ResourceLocation texture = ThrowableConfig.getTexture(itemId, path);
                gun.preparedTextures.put((String)variant, texture);
            }));
        }
    }

    @NotNull
    private static ResourceLocation getTexture(String itemId, ResourceLocation path) {
        return ResourceLocation.m_214293_((String)path.m_135827_(), (String)("textures/guns/" + itemId + "/" + path.m_135815_() + ".png"));
    }

    public static class General
    implements INBTSerializable<CompoundTag> {
        @Optional
        LinkedHashSet<ThrowMode> mode = new LinkedHashSet<ThrowMode>(List.of(ThrowMode.SAFE));
        private int equipTime = 0;
        private int prepareTime = 0;
        private int throwTime = 1;

        public static General create(CompoundTag tag) {
            General config = new General();
            config.deserializeNBT(tag);
            return config;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("mode", (Tag)NbtUtils.serializeSet(this.mode));
            tag.m_128405_(ThrowableConfig.EQUIP_TIME, this.equipTime);
            tag.m_128405_(ThrowableConfig.PREPARE_TIME, this.prepareTime);
            tag.m_128405_(ThrowableConfig.THROW_TIME, this.throwTime);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("mode", 10)) {
                this.mode = NbtUtils.deserializeSet(tag.m_128469_("mode"), ThrowMode::getType);
            }
            if (tag.m_128425_(ThrowableConfig.EQUIP_TIME, 3)) {
                this.equipTime = tag.m_128451_(ThrowableConfig.EQUIP_TIME);
            }
            if (tag.m_128425_(ThrowableConfig.PREPARE_TIME, 3)) {
                this.prepareTime = tag.m_128451_(ThrowableConfig.PREPARE_TIME);
            }
            if (tag.m_128425_(ThrowableConfig.THROW_TIME, 3)) {
                this.throwTime = tag.m_128451_(ThrowableConfig.THROW_TIME);
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            object.addProperty("mode", this.mode.toString());
            object.addProperty(ThrowableConfig.EQUIP_TIME, (Number)this.equipTime);
            object.addProperty(ThrowableConfig.PREPARE_TIME, (Number)this.prepareTime);
            object.addProperty(ThrowableConfig.THROW_TIME, (Number)this.throwTime);
            return object;
        }

        public General copy() {
            General gun = new General();
            gun.mode = (LinkedHashSet)this.mode.clone();
            gun.equipTime = this.equipTime;
            gun.prepareTime = this.prepareTime;
            gun.throwTime = this.throwTime;
            return gun;
        }

        public LinkedHashSet<ThrowMode> getThrowModes() {
            return this.mode;
        }

        public int getEquipTime() {
            return this.equipTime;
        }

        public int getPrepareTime() {
            return this.prepareTime;
        }

        public int getThrowTime() {
            return this.throwTime;
        }
    }

    public static class Builder {
        private final ThrowableConfig gun;

        private Builder() {
            this.gun = new ThrowableConfig();
        }

        private Builder(ThrowableConfig gun) {
            this.gun = gun.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(ThrowableConfig gun) {
            return new Builder(gun);
        }

        public ThrowableConfig build() {
            return this.gun.copy();
        }
    }
}

