/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.attachment;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.data.config.attachment.Modifiers;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.util.annotation.Ignored;
import com.nukateam.ntgl.common.util.annotation.Optional;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class AttachmentConfig
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    public static final String ATTACHMENT_TYPE = "AttachmentType";
    public static final String MODIFIERS = "modifiers";
    @Ignored
    private AttachmentType type;
    @Optional
    private Modifiers modifiers = new Modifiers();

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(ATTACHMENT_TYPE, this.type.toString());
        tag.m_128365_(MODIFIERS, (Tag)this.modifiers.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_(ATTACHMENT_TYPE, 8)) {
            this.type = AttachmentType.getType(ResourceLocation.m_135820_((String)tag.m_128461_(ATTACHMENT_TYPE)));
        }
        if (tag.m_128441_(MODIFIERS)) {
            this.modifiers.deserializeNBT(tag.m_128469_(MODIFIERS));
        }
    }

    public static AttachmentConfig create(ResourceLocation id, CompoundTag tag) {
        AttachmentConfig attachment = new AttachmentConfig();
        attachment.deserializeNBT(tag);
        return attachment;
    }

    public AttachmentConfig copy() {
        AttachmentConfig projectile = new AttachmentConfig();
        projectile.type = this.type;
        projectile.modifiers = this.modifiers.copy();
        return projectile;
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        object.addProperty("type", this.type.toString());
        object.add(MODIFIERS, (JsonElement)this.modifiers.toJsonObject());
        return object;
    }

    public AttachmentType getType() {
        return this.type;
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Attachment");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {});
    }

    public static class Builder {
        private final AttachmentConfig attachment;

        private Builder() {
            this.attachment = new AttachmentConfig();
        }

        private Builder(AttachmentConfig attachment) {
            this.attachment = attachment.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(AttachmentConfig attachment) {
            return new Builder(attachment);
        }

        public Builder setType(AttachmentType type) {
            this.attachment.type = type;
            return this;
        }

        public AttachmentConfig build() {
            return this.attachment.copy();
        }
    }
}

