/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.attachment;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.data.holders.GripType;
import com.nukateam.ntgl.common.data.holders.LoadingType;
import com.nukateam.ntgl.common.util.annotation.Optional;
import com.nukateam.ntgl.common.util.interfaces.IGunModifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class Modifiers
implements INBTSerializable<CompoundTag>,
IGunModifier {
    @Optional
    Set<FireMode> fireModes = new HashSet<FireMode>();
    @Optional
    float additionalDamage = 0.0f;
    @Optional
    String damage = "";
    @Optional
    String projectileSpeed = "";
    @Optional
    String spread = "";
    @Optional
    float additionalProjectileGravity = 0.0f;
    @Optional
    String projectileGravity = "";
    @Optional
    String projectileLife = "";
    @Optional
    float recoilModifier = 1.0f;
    @Optional
    float kickModifier = 1.0f;
    @Optional
    float criticalChance = 0.0f;
    @Optional
    String muzzleFlashSize = "";
    @Optional
    String muzzleFlashScale = "";
    @Optional
    String aimDownSightSpeed = "";
    @Optional
    String rate = "";
    @Optional
    String maxAmmo = "";
    @Optional
    String projectileAmount = "";
    @Optional
    String fireDelay = "";
    @Optional
    String reloadStart = "";
    @Optional
    String reloadTime = "";
    @Optional
    String reloadEnd = "";
    @Optional
    String equipTime = "";
    @Optional
    String ammoPerShot = "";
    @Optional
    String fireSoundVolume = "";
    @Optional
    String fireSound = "";
    @Optional
    String silencedFire = "";
    @Optional
    HashMap<AmmoHolder, Integer> maxFuel = new HashMap();
    @Optional
    GripType gripType = null;
    @Optional
    String needsFullCharge = "";
    @Optional
    String oneTimeCharge = "";
    @Optional
    Set<AmmoHolder> ammoItems = new HashSet<AmmoHolder>();
    @Optional
    String autoReload = "";
    @Optional
    String renderHud = "";
    @Optional
    LoadingType loadingType = null;
    @Optional
    Set<AmmoHolder> fuel = new HashSet<AmmoHolder>();

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("fireSoundVolume", this.fireSoundVolume);
        tag.m_128359_("fireSound", this.fireSound);
        tag.m_128359_("silencedFire", this.silencedFire);
        tag.m_128350_("additionalDamage", this.additionalDamage);
        tag.m_128359_("damage", this.damage);
        tag.m_128359_("projectileSpeed", this.projectileSpeed);
        tag.m_128359_("spread", this.spread);
        tag.m_128350_("additionalProjectileGravity", this.additionalProjectileGravity);
        tag.m_128359_("projectileGravity", this.projectileGravity);
        tag.m_128359_("projectileLife", this.projectileLife);
        tag.m_128350_("recoilModifier", this.recoilModifier);
        tag.m_128350_("kickModifier", this.kickModifier);
        tag.m_128359_("muzzleFlashSize", this.muzzleFlashSize);
        tag.m_128359_("muzzleFlashScale", this.muzzleFlashScale);
        tag.m_128359_("aimDownSightSpeed", this.aimDownSightSpeed);
        tag.m_128359_("rate", this.rate);
        tag.m_128350_("criticalChance", this.criticalChance);
        tag.m_128359_("maxAmmo", this.maxAmmo);
        tag.m_128359_("projectileAmount", this.projectileAmount);
        tag.m_128359_("fireDelay", this.fireDelay);
        tag.m_128359_("reloadStart", this.reloadStart);
        tag.m_128359_("reloadTime", this.reloadTime);
        tag.m_128359_("reloadEnd", this.reloadEnd);
        tag.m_128359_("equipTime", this.equipTime);
        tag.m_128359_("ammoPerShot", this.ammoPerShot);
        this.writeFireModes(tag);
        this.writeGripType(tag);
        tag.m_128359_("needsFullCharge", this.needsFullCharge);
        tag.m_128359_("oneTimeCharge", this.oneTimeCharge);
        this.writeAmmoItems(tag);
        tag.m_128359_("autoReload", this.autoReload);
        tag.m_128359_("renderHud", this.renderHud);
        this.writeLoadingType(tag);
        this.writeFuelTypes(tag);
        this.writeFuelMax(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("fireSoundVolume", 8)) {
            this.fireSoundVolume = tag.m_128461_("fireSoundVolume");
        }
        if (tag.m_128425_("fireSound", 8)) {
            this.fireSound = tag.m_128461_("fireSound");
        }
        if (tag.m_128425_("silencedFire", 1)) {
            this.silencedFire = tag.m_128461_("silencedFire");
        }
        if (tag.m_128425_("additionalDamage", 5)) {
            this.additionalDamage = tag.m_128457_("additionalDamage");
        }
        if (tag.m_128425_("damage", 8)) {
            this.damage = tag.m_128461_("damage");
        }
        if (tag.m_128425_("projectileSpeed", 8)) {
            this.projectileSpeed = tag.m_128461_("projectileSpeed");
        }
        if (tag.m_128425_("spread", 8)) {
            this.spread = tag.m_128461_("spread");
        }
        if (tag.m_128425_("additionalProjectileGravity", 5)) {
            this.additionalProjectileGravity = tag.m_128457_("additionalProjectileGravity");
        }
        if (tag.m_128425_("projectileGravity", 8)) {
            this.projectileGravity = tag.m_128461_("projectileGravity");
        }
        if (tag.m_128425_("projectileLife", 8)) {
            this.projectileLife = tag.m_128461_("projectileLife");
        }
        if (tag.m_128425_("recoilModifier", 5)) {
            this.recoilModifier = tag.m_128457_("recoilModifier");
        }
        if (tag.m_128425_("kickModifier", 5)) {
            this.kickModifier = tag.m_128457_("kickModifier");
        }
        if (tag.m_128425_("muzzleFlashSize", 8)) {
            this.muzzleFlashSize = tag.m_128461_("muzzleFlashSize");
        }
        if (tag.m_128425_("muzzleFlashScale", 8)) {
            this.muzzleFlashScale = tag.m_128461_("muzzleFlashScale");
        }
        if (tag.m_128425_("aimDownSightSpeed", 8)) {
            this.aimDownSightSpeed = tag.m_128461_("aimDownSightSpeed");
        }
        if (tag.m_128425_("rate", 8)) {
            this.rate = tag.m_128461_("rate");
        }
        if (tag.m_128425_("criticalChance", 5)) {
            this.criticalChance = tag.m_128457_("criticalChance");
        }
        if (tag.m_128425_("maxAmmo", 8)) {
            this.maxAmmo = tag.m_128461_("maxAmmo");
        }
        if (tag.m_128425_("projectileAmount", 8)) {
            this.projectileAmount = tag.m_128461_("projectileAmount");
        }
        if (tag.m_128425_("fireDelay", 8)) {
            this.fireDelay = tag.m_128461_("fireDelay");
        }
        if (tag.m_128425_("reloadStart", 8)) {
            this.reloadStart = tag.m_128461_("reloadStart");
        }
        if (tag.m_128425_("reloadTime", 8)) {
            this.reloadTime = tag.m_128461_("reloadTime");
        }
        if (tag.m_128425_("reloadEnd", 8)) {
            this.reloadEnd = tag.m_128461_("reloadEnd");
        }
        if (tag.m_128425_("equipTime", 8)) {
            this.equipTime = tag.m_128461_("equipTime");
        }
        if (tag.m_128425_("ammoPerShot", 8)) {
            this.ammoPerShot = tag.m_128461_("ammoPerShot");
        }
        this.readFireModes(tag);
        this.readGripType(tag);
        if (tag.m_128425_("needsFullCharge", 1)) {
            this.needsFullCharge = tag.m_128461_("needsFullCharge");
        }
        if (tag.m_128425_("oneTimeCharge", 1)) {
            this.oneTimeCharge = tag.m_128461_("oneTimeCharge");
        }
        this.readAmmoItems(tag);
        if (tag.m_128425_("autoReload", 1)) {
            this.autoReload = tag.m_128461_("autoReload");
        }
        if (tag.m_128425_("renderHud", 1)) {
            this.renderHud = tag.m_128461_("renderHud");
        }
        this.readLoadingType(tag);
        this.readFuelTypes(tag);
        this.readFuelMax(tag);
    }

    private void writeFireModes(CompoundTag tag) {
        ListTag list = new ListTag();
        this.fireModes.forEach(mode -> list.add((Object)StringTag.m_129297_((String)mode.toString())));
        tag.m_128365_("fireModes", (Tag)list);
    }

    private void readFireModes(CompoundTag tag) {
        if (tag.m_128425_("fireModes", 9)) {
            this.fireModes.clear();
            tag.m_128437_("fireModes", 8).forEach(t -> this.fireModes.add(FireMode.getType(t.m_7916_())));
        }
    }

    private void writeGripType(CompoundTag tag) {
        if (this.gripType != null) {
            tag.m_128359_("gripType", this.gripType.toString());
        }
    }

    private void readGripType(CompoundTag tag) {
        if (tag.m_128425_("gripType", 8)) {
            this.gripType = GripType.getType(tag.m_128461_("gripType"));
        }
    }

    private void writeAmmoItems(CompoundTag tag) {
        ListTag list = new ListTag();
        this.ammoItems.forEach(item -> list.add((Object)StringTag.m_129297_((String)item.toString())));
        tag.m_128365_("ammoItems", (Tag)list);
    }

    private void readAmmoItems(CompoundTag tag) {
        if (tag.m_128425_("ammoItems", 9)) {
            this.ammoItems.clear();
            tag.m_128437_("ammoItems", 8).forEach(t -> this.ammoItems.add(AmmoHolder.getType(t.m_7916_())));
        }
    }

    private void writeLoadingType(CompoundTag tag) {
        if (this.loadingType != null) {
            tag.m_128359_("loadingType", this.loadingType.toString());
        }
    }

    private void readLoadingType(CompoundTag tag) {
        if (tag.m_128425_("loadingType", 8)) {
            this.loadingType = LoadingType.getType(tag.m_128461_("loadingType"));
        }
    }

    private void writeFuelTypes(CompoundTag tag) {
        ListTag list = new ListTag();
        this.fuel.forEach(type -> list.add((Object)StringTag.m_129297_((String)type.toString())));
        tag.m_128365_("fuel", (Tag)list);
    }

    private void readFuelTypes(CompoundTag tag) {
        if (tag.m_128425_("fuel", 9)) {
            this.fuel.clear();
            tag.m_128437_("fuel", 8).forEach(t -> this.fuel.add(AmmoHolder.getType(t.m_7916_())));
        }
    }

    private void writeFuelMax(CompoundTag tag) {
        CompoundTag fuelTag = new CompoundTag();
        this.maxFuel.forEach((key, value) -> fuelTag.m_128405_(key.toString(), value.intValue()));
        tag.m_128365_("maxFuel", (Tag)fuelTag);
    }

    private void readFuelMax(CompoundTag tag) {
        if (tag.m_128425_("maxFuel", 10)) {
            CompoundTag fuelTag = tag.m_128469_("maxFuel");
            fuelTag.m_128431_().forEach(key -> this.maxFuel.put(AmmoHolder.getType(key), fuelTag.m_128451_(key)));
        }
    }

    public Modifiers copy() {
        Modifiers copy = new Modifiers();
        copy.fireSoundVolume = this.fireSoundVolume;
        copy.fireSound = this.fireSound;
        copy.silencedFire = this.silencedFire;
        copy.additionalDamage = this.additionalDamage;
        copy.damage = this.damage;
        copy.projectileSpeed = this.projectileSpeed;
        copy.spread = this.spread;
        copy.additionalProjectileGravity = this.additionalProjectileGravity;
        copy.projectileGravity = this.projectileGravity;
        copy.projectileLife = this.projectileLife;
        copy.recoilModifier = this.recoilModifier;
        copy.kickModifier = this.kickModifier;
        copy.muzzleFlashSize = this.muzzleFlashSize;
        copy.muzzleFlashScale = this.muzzleFlashScale;
        copy.aimDownSightSpeed = this.aimDownSightSpeed;
        copy.rate = this.rate;
        copy.criticalChance = this.criticalChance;
        copy.maxAmmo = this.maxAmmo;
        copy.projectileAmount = this.projectileAmount;
        copy.fireDelay = this.fireDelay;
        copy.reloadStart = this.reloadStart;
        copy.reloadTime = this.reloadTime;
        copy.reloadEnd = this.reloadEnd;
        copy.equipTime = this.equipTime;
        copy.ammoPerShot = this.ammoPerShot;
        copy.maxFuel = new HashMap<AmmoHolder, Integer>(this.maxFuel);
        copy.fireModes = new HashSet<FireMode>(this.fireModes);
        copy.gripType = this.gripType;
        copy.needsFullCharge = this.needsFullCharge;
        copy.oneTimeCharge = this.oneTimeCharge;
        copy.ammoItems = new HashSet<AmmoHolder>(this.ammoItems);
        copy.autoReload = this.autoReload;
        copy.renderHud = this.renderHud;
        copy.loadingType = this.loadingType;
        copy.fuel = new HashSet<AmmoHolder>(this.fuel);
        return copy;
    }

    public JsonObject toJsonObject() {
        JsonObject json = new JsonObject();
        json.addProperty("fireSoundVolume", this.fireSoundVolume);
        json.addProperty("fireSound", this.fireSound);
        json.addProperty("silencedFire", this.silencedFire);
        json.addProperty("additionalDamage", (Number)Float.valueOf(this.additionalDamage));
        json.addProperty("damage", this.damage);
        json.addProperty("projectileSpeed", this.projectileSpeed);
        json.addProperty("spread", this.spread);
        json.addProperty("additionalProjectileGravity", (Number)Float.valueOf(this.additionalProjectileGravity));
        json.addProperty("projectileGravity", this.projectileGravity);
        json.addProperty("projectileLife", this.projectileLife);
        json.addProperty("recoilModifier", (Number)Float.valueOf(this.recoilModifier));
        json.addProperty("kickModifier", (Number)Float.valueOf(this.kickModifier));
        json.addProperty("muzzleFlashSize", this.muzzleFlashSize);
        json.addProperty("muzzleFlashScale", this.muzzleFlashScale);
        json.addProperty("aimDownSightSpeed", this.aimDownSightSpeed);
        json.addProperty("rate", this.rate);
        json.addProperty("criticalChance", (Number)Float.valueOf(this.criticalChance));
        json.addProperty("maxAmmo", this.maxAmmo);
        json.addProperty("projectileAmount", this.projectileAmount);
        json.addProperty("fireDelay", this.fireDelay);
        json.addProperty("reloadStart", this.reloadStart);
        json.addProperty("reloadTime", this.reloadTime);
        json.addProperty("reloadEnd", this.reloadEnd);
        json.addProperty("equipTime", this.equipTime);
        json.addProperty("ammoPerShot", this.ammoPerShot);
        JsonObject fuelJson = new JsonObject();
        this.maxFuel.forEach((key, value) -> fuelJson.addProperty(key.toString(), (Number)value));
        json.add("maxFuel", (JsonElement)fuelJson);
        JsonArray fireModesArray = new JsonArray();
        this.fireModes.forEach(mode -> fireModesArray.add(mode.toString()));
        json.add("fireModes", (JsonElement)fireModesArray);
        return json;
    }

    @Override
    public float modifyFireSoundVolume(float volume, GunData data) {
        return IGunModifier.super.modifyFireSoundVolume(volume, data);
    }

    @Override
    public ResourceLocation modifyFireSound(ResourceLocation sound, GunData data) {
        return IGunModifier.super.modifyFireSound(sound, data);
    }

    @Override
    public double modifyFireSoundRadius(double radius, GunData data) {
        return IGunModifier.super.modifyFireSoundRadius(radius, data);
    }

    @Override
    public boolean silencedFire(GunData data) {
        return Modifiers.getBoolean(false, this.silencedFire);
    }

    @Override
    public boolean modifyNeedsFullCharge(boolean base, GunData data) {
        return Modifiers.getBoolean(base, this.needsFullCharge);
    }

    @Override
    public boolean modifyIsOneTimeCharge(boolean base, GunData data) {
        return Modifiers.getBoolean(base, this.oneTimeCharge);
    }

    @Override
    public boolean modifyShouldRenderHud(boolean base, GunData data) {
        return Modifiers.getBoolean(base, this.renderHud);
    }

    @Override
    public Set<AmmoHolder> modifyAmmoItems(Set<AmmoHolder> baseValue, GunData data) {
        return this.ammoItems != null && !this.ammoItems.isEmpty() ? this.ammoItems : baseValue;
    }

    @Override
    public boolean modifyAutoReloading(boolean base, GunData data) {
        return Modifiers.getBoolean(base, this.autoReload);
    }

    @Override
    public LoadingType modifyLoadingType(LoadingType baseValue, GunData data) {
        return this.loadingType != null ? this.loadingType : baseValue;
    }

    @Override
    public Set<AmmoHolder> modifyFuelItems(Set<AmmoHolder> baseValue, GunData data) {
        return this.fuel != null && !this.fuel.isEmpty() ? this.fuel : baseValue;
    }

    @Override
    public Set<FireMode> modifyFireModes(Set<FireMode> baseValue, GunData data) {
        return this.fireModes != null && !this.fireModes.isEmpty() ? this.fireModes : baseValue;
    }

    @Override
    public GripType modifyGripType(GripType baseValue, GunData data) {
        return this.gripType != null ? this.gripType : baseValue;
    }

    @Override
    public float additionalDamage(GunData gunData) {
        return this.additionalDamage;
    }

    @Override
    public float modifyDamage(float damage, GunData gunData) {
        return Modifiers.calculate(damage, this.damage);
    }

    @Override
    public double modifyProjectileSpeed(double speed, GunData gunData) {
        return Modifiers.calculate((float)speed, this.projectileSpeed);
    }

    @Override
    public float modifyProjectileSpread(float spread, GunData gunData) {
        return Modifiers.calculate(spread, this.spread);
    }

    @Override
    public double additionalProjectileGravity(GunData gunData) {
        return this.additionalProjectileGravity;
    }

    @Override
    public double modifyProjectileGravity(double gravity, GunData gunData) {
        return Modifiers.calculate((float)gravity, this.projectileGravity);
    }

    @Override
    public int modifyProjectileLife(int life, GunData gunData) {
        return (int)Modifiers.calculate(life, this.projectileLife);
    }

    @Override
    public float recoilModifier(GunData gunData) {
        return this.recoilModifier;
    }

    @Override
    public float kickModifier(GunData gunData) {
        return this.kickModifier;
    }

    @Override
    public double modifyMuzzleFlashSize(double size, GunData gunData) {
        return Modifiers.calculate((float)size, this.muzzleFlashSize);
    }

    @Override
    public double modifyMuzzleFlashScale(double scale, GunData gunData) {
        return Modifiers.calculate((float)scale, this.muzzleFlashScale);
    }

    @Override
    public double modifyAimDownSightSpeed(double speed, GunData gunData) {
        return Modifiers.calculate((float)speed, this.aimDownSightSpeed);
    }

    @Override
    public int modifyFireRate(int base, GunData gunData) {
        return (int)Modifiers.calculate(base, this.rate);
    }

    @Override
    public float criticalChance(GunData gunData) {
        return this.criticalChance;
    }

    @Override
    public int modifyMaxAmmo(int maxAmmo, GunData gunData) {
        return (int)Modifiers.calculate(maxAmmo, this.maxAmmo);
    }

    @Override
    public int modifyProjectileAmount(int amount, GunData gunData) {
        return (int)Modifiers.calculate(amount, this.projectileAmount);
    }

    @Override
    public int modifyFireDelay(int delay, GunData gunData) {
        return (int)Modifiers.calculate(delay, this.fireDelay);
    }

    @Override
    public int modifyReloadStart(int time, GunData gunData) {
        return (int)Modifiers.calculate(time, this.reloadStart);
    }

    @Override
    public int modifyReloadTime(int time, GunData gunData) {
        return (int)Modifiers.calculate(time, this.reloadTime);
    }

    @Override
    public int modifyReloadEnd(int time, GunData gunData) {
        return (int)Modifiers.calculate(time, this.reloadEnd);
    }

    @Override
    public int modifyEquipTime(int time, GunData gunData) {
        return (int)Modifiers.calculate(time, this.equipTime);
    }

    @Override
    public int modifyAmmoPerShot(int ammo, GunData gunData) {
        return (int)Modifiers.calculate(ammo, this.ammoPerShot);
    }

    public int modifyMaxFuel(int max, AmmoHolder type, GunData gunData) {
        return this.maxFuel != null && this.maxFuel.get(type) != null ? this.maxFuel.get(type) : max;
    }

    public static boolean getBoolean(boolean base, String mod) {
        if (mod == null || mod.isEmpty()) {
            return base;
        }
        switch (mod) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        Ntgl.LOGGER.error("Invalid boolean  {}", (Object)mod);
        return base;
    }

    public static float calculate(float num, String operation) {
        if (operation == null || operation.isEmpty()) {
            return num;
        }
        try {
            char firstChar = operation.charAt(0);
            if (Modifiers.isOperator(firstChar)) {
                float operand = Modifiers.parseOperand(operation.substring(1));
                return Modifiers.applyOperation(num, firstChar, operand);
            }
            return Modifiers.parseOperand(operation);
        }
        catch (NumberFormatException e) {
            IllegalArgumentException throwable = new IllegalArgumentException("Invalid number format in operation: " + operation, e);
            Ntgl.LOGGER.error("Invalid number format in operation: {}", (Object)operation, (Object)throwable);
            return num;
        }
    }

    private static boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/';
    }

    private static float parseOperand(String numberStr) {
        return Float.parseFloat(numberStr);
    }

    private static float applyOperation(float num, char operator, float operand) {
        return switch (operator) {
            case '+' -> num + operand;
            case '-' -> num - operand;
            case '*' -> num * operand;
            case '/' -> {
                if ((double)operand == 0.0) {
                    Ntgl.LOGGER.error("Division by zero", (Throwable)new ArithmeticException("Division by zero"));
                    yield num;
                }
                yield num / operand;
            }
            default -> {
                Ntgl.LOGGER.error("Unsupported operator: {}", (Object)Character.valueOf(operator), (Object)new IllegalArgumentException("Unsupported operator: " + operator));
                yield num / operand;
            }
        };
    }
}

