/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.holders;

import com.nukateam.ntgl.common.data.holders.ResourceHolder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class AmmoType
extends ResourceHolder {
    public static AmmoType STANDARD = new AmmoType("standard");
    public static AmmoType PIERCING = new AmmoType("piercing");
    public static AmmoType INCENDIARY = new AmmoType("incendiary");
    public static AmmoType LASER = new AmmoType("laser");
    public static AmmoType TESLA = new AmmoType("tesla");
    public static AmmoType ENERGETIC = new AmmoType("energetic");
    public static AmmoType ROCKET = new AmmoType("rocket");
    public static AmmoType EXPLOSIVE = new AmmoType("explosive");
    public static AmmoType EXPLOSIVE_INCENDIARY = new AmmoType("explosive_incendiary");
    public static AmmoType FIRE = new AmmoType("fire");
    public static AmmoType SLUG = new AmmoType("slug");
    public static AmmoType BUCKSHOT = new AmmoType("buckshot");
    public static AmmoType BURNABLE = new AmmoType("burnable");
    public static AmmoType WATER = new AmmoType("water");
    private static final Map<ResourceLocation, AmmoType> typeMap = new HashMap<ResourceLocation, AmmoType>();

    public AmmoType(ResourceLocation id) {
        super(id);
    }

    public AmmoType(String name) {
        super(name);
    }

    public ResourceLocation getIcon() {
        return ResourceLocation.m_214293_((String)this.id.m_135827_(), (String)("textures/hud/ammo_type/" + this.id.m_135815_() + ".png"));
    }

    public static void registerType(AmmoType mode) {
        typeMap.putIfAbsent(mode.getId(), mode);
    }

    public static AmmoType getType(ResourceLocation id) {
        return typeMap.getOrDefault(id, STANDARD);
    }

    public static AmmoType getType(String path) {
        ResourceLocation id = ResourceLocation.m_135820_((String)path);
        return AmmoType.getType(id);
    }

    static {
        AmmoType.registerType(STANDARD);
        AmmoType.registerType(PIERCING);
        AmmoType.registerType(INCENDIARY);
        AmmoType.registerType(LASER);
        AmmoType.registerType(TESLA);
        AmmoType.registerType(ROCKET);
        AmmoType.registerType(ENERGETIC);
        AmmoType.registerType(EXPLOSIVE);
        AmmoType.registerType(EXPLOSIVE_INCENDIARY);
        AmmoType.registerType(FIRE);
        AmmoType.registerType(SLUG);
        AmmoType.registerType(BUCKSHOT);
        AmmoType.registerType(BURNABLE);
        AmmoType.registerType(WATER);
    }
}

