/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.debug;

import com.nukateam.ntgl.client.handlers.ClientHandler;
import com.nukateam.ntgl.common.data.attachment.impl.Scope;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.debug.screen.widget.DebugButton;
import com.nukateam.ntgl.common.debug.screen.widget.DebugToggle;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.foundation.item.attachment.ScopeItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="ntgl")
public class Debug {
    private static final Map<Item, Gun> GUNS = new HashMap<Item, Gun>();
    private static final Map<Item, Scope> SCOPES = new HashMap<Item, Scope>();
    private static boolean forceAim = false;

    @SubscribeEvent
    public static void onServerStarting(ServerStartedEvent event) {
        event.getServer().execute(() -> {
            GUNS.clear();
            SCOPES.clear();
        });
    }

    public static Gun getGun(WeaponItem item) {
        return GUNS.computeIfAbsent(item, item1 -> item.getGun().copy());
    }

    public static Scope getScope(ScopeItem item) {
        return SCOPES.computeIfAbsent(item, item1 -> ((Scope)item.getProperties()).copy());
    }

    public static boolean isForceAim() {
        return forceAim;
    }

    public static void setForceAim(boolean forceAim) {
        Debug.forceAim = forceAim;
    }

    public static class Settings
    implements IEditorMenu {
        @Override
        public Component getEditorLabel() {
            return Component.m_237113_((String)"Settings");
        }

        @Override
        public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> widgets.add(Pair.of((Object)Component.m_237113_((String)"Force Aim"), () -> new DebugToggle(forceAim, value -> {
                forceAim = value;
            }))));
        }
    }

    public static class Menu
    implements IEditorMenu {
        @Override
        public Component getEditorLabel() {
            return Component.m_237113_((String)"Editor Menu");
        }

        @Override
        public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                ItemStack heldItem = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_21205_();
                Item patt2609$temp = heldItem.m_41720_();
                if (patt2609$temp instanceof WeaponItem) {
                    WeaponItem weaponItem = (WeaponItem)patt2609$temp;
                    widgets.add(Pair.of((Object)Component.m_237115_((String)weaponItem.m_5524_()), () -> new DebugButton((Component)Component.m_237113_((String)"Edit"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(Debug.getGun(weaponItem))))));
                }
                widgets.add(Pair.of((Object)Component.m_237113_((String)"Settings"), () -> new DebugButton((Component)Component.m_237113_((String)">"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(new Settings())))));
            });
        }
    }
}

