/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.entity;

import com.nukateam.ntgl.ClientProxy;
import com.nukateam.ntgl.common.foundation.entity.projectile.DeathEffect;
import com.nukateam.ntgl.common.foundation.entity.projectile.GoreData;
import com.nukateam.ntgl.common.foundation.init.ModEntityTypes;
import com.nukateam.ntgl.common.foundation.init.ModParticleTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;

public class FlyingGib
extends Entity {
    public static final EntityDataAccessor<Integer> ENTITY = SynchedEntityData.m_135353_(FlyingGib.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> PART = SynchedEntityData.m_135353_(FlyingGib.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(FlyingGib.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> GRAVITY = SynchedEntityData.m_135353_(FlyingGib.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<CompoundTag> DATA = SynchedEntityData.m_135353_(FlyingGib.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public static final int LIFE = 60;
    private final Lazy<LivingEntity> localEntity = Lazy.of(() -> (LivingEntity)Minecraft.m_91087_().f_91073_.m_6815_(this.getEntityId()));
    private RandomSource rand = this.m_9236_().m_213780_();
    public int maxTimeToLive = 60;
    public int timeToLive = 60;
    public double gravity = 0.03f;
    public Vec3 rotationAxis = new Vec3((double)this.rand.m_216339_(0, 90), (double)this.rand.m_216339_(0, 90), (double)this.rand.m_216339_(0, 90));
    public int hitGroundTTL = 0;
    public float size;
    public GoreData data;

    public FlyingGib(EntityType<FlyingGib> type, Level level) {
        super(type, level);
    }

    public FlyingGib(Level world, LivingEntity entity, GoreData data, Vec3 pos, Vec3 delta, float size, int bodyPart) {
        this((EntityType<FlyingGib>)((EntityType)ModEntityTypes.FLYING_GIBS.get()), world);
        this.m_146884_(pos);
        this.rand = this.m_9236_().m_213780_();
        this.size = size;
        this.timeToLive = this.maxTimeToLive = 60 + this.rand.m_188503_(50);
        this.rotationAxis = new Vec3(this.rand.m_188500_(), this.rand.m_188500_(), this.rand.m_188500_());
        this.data = data;
        this.m_20256_(delta);
        this.m_19915_(entity.m_146908_(), this.m_146909_());
        this.m_20088_().m_135381_(ENTITY, (Object)entity.m_19879_());
        this.m_20088_().m_135381_(PART, (Object)bodyPart);
        this.m_20088_().m_135381_(SIZE, (Object)Float.valueOf(size));
        this.m_20088_().m_135381_(DATA, (Object)data.serializeNBT());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ENTITY, (Object)-1);
        this.f_19804_.m_135372_(PART, (Object)0);
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(GRAVITY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA, (Object)new CompoundTag());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.timeToLive > 0) {
            --this.timeToLive;
        } else {
            this.m_6074_();
        }
        this.handleLavaMovement();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_20096_()) {
            if (this.hitGroundTTL == 0) {
                this.hitGroundTTL = this.timeToLive;
            }
            BlockPos pos = this.m_20099_();
            float friction = this.m_9236_().m_8055_(pos).getFriction((LevelReader)this.m_9236_(), pos, (Entity)this) * 0.98f / 5.0f;
            this.m_20256_(this.m_20184_().m_82542_((double)(friction *= 0.91f), 0.98, (double)friction));
        }
        float motionScale = this.m_20069_() ? this.getWaterInertia() : 1.0f;
        this.m_20256_(this.m_20184_().m_82490_((double)motionScale));
        this.handleGravity();
        this.particleTick();
    }

    public Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 pDeltaMovement, float pFriction) {
        this.m_19920_(this.getFrictionInfluencedSpeed(pFriction), pDeltaMovement);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        Vec3 vec3 = this.m_20184_();
        if (this.f_19862_ && this.m_146900_().m_60713_(Blocks.f_152499_) && PowderSnowBlock.m_154255_((Entity)this)) {
            vec3 = new Vec3(vec3.f_82479_, 0.2, vec3.f_82481_);
        }
        return vec3;
    }

    private float getFrictionInfluencedSpeed(float pFriction) {
        return this.m_20096_() ? 1.5f * (0.21600002f / (pFriction * pFriction * pFriction)) : 0.02f;
    }

    public void onRemovedFromWorld() {
        DeathEffect.goreStats.remove(this.getEntityId());
        super.onRemovedFromWorld();
    }

    private void particleTick() {
        if (this.m_9236_().f_46443_ && this.getData().showBlood) {
            for (int i = 5; i > 0; --i) {
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.BLOOD.get(), true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
            }
        }
    }

    private void handleGravity() {
        this.m_245125_();
        float gravity = this.getData().gravity;
        Vec3 vec3 = this.m_20184_();
        float f = this.m_146909_() * ((float)Math.PI / 180);
        double d5 = Math.cos(f);
        vec3 = this.m_20184_().m_82520_(0.0, (double)gravity * (-1.0 + d5 * 0.75), 0.0);
        this.m_20256_(vec3.m_82542_((double)0.99f, (double)0.95f, (double)0.99f));
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    private void handleLavaMovement() {
        if (this.m_9236_().m_8055_(ClientProxy.getEntityBlockPos(this)).m_60819_().m_205070_(FluidTags.f_13132_)) {
            RandomSource rand = this.m_9236_().m_213780_();
            this.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + rand.m_188501_() * 0.4f);
        }
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public int getEntityId() {
        return (Integer)this.m_20088_().m_135370_(ENTITY);
    }

    public int getPartId() {
        return (Integer)this.m_20088_().m_135370_(PART);
    }

    public float getSize() {
        return ((Float)this.m_20088_().m_135370_(SIZE)).floatValue();
    }

    public float getGravity() {
        return ((Float)this.m_20088_().m_135370_(GRAVITY)).floatValue();
    }

    public GoreData getData() {
        if (this.data == null) {
            this.data = new GoreData();
            this.data.deserializeNBT((CompoundTag)this.m_20088_().m_135370_(DATA));
        }
        return this.data;
    }

    @OnlyIn(value=Dist.CLIENT)
    public LivingEntity getLocalEntity() {
        return (LivingEntity)this.localEntity.get();
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }
}

