/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.entity;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.common.foundation.entity.throwable.ThrowableGrenadeEntity;
import com.nukateam.ntgl.common.foundation.entity.throwable.ThrowableItemEntity;
import com.nukateam.ntgl.common.foundation.init.ModEffects;
import com.nukateam.ntgl.common.foundation.init.ModSounds;
import com.nukateam.ntgl.common.foundation.init.Projectiles;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.S2CMessageStunGrenade;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class StunGrenadeEntity<T extends Item>
extends ThrowableGrenadeEntity<T> {
    public StunGrenadeEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, Level world) {
        super(entityType, world);
    }

    public StunGrenadeEntity(Level world, LivingEntity player, T item, int maxCookTime) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)Projectiles.THROWABLE_STUN_GRENADE.get()), world, player, item, maxCookTime);
        this.setItem(new ItemStack(item));
    }

    @SubscribeEvent
    public static void blindMobs(LivingChangeTargetEvent event) {
        if (((Boolean)Config.COMMON.stunGrenades.blind.blindMobs.get()).booleanValue() && event.getOriginalTarget() != null && event.getEntity() instanceof Mob && event.getEntity().m_21023_((MobEffect)ModEffects.BLINDED.get())) {
            ((Mob)event.getEntity()).m_6710_(null);
        }
    }

    @Override
    public void onDeath() {
        double y = this.m_20186_() + (double)this.m_6095_().m_20680_().f_20378_ * 0.5;
        this.m_9236_().m_6263_(null, this.m_20185_(), y, this.m_20189_(), (SoundEvent)ModSounds.ENTITY_STUN_GRENADE_EXPLOSION.get(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
        if (this.m_9236_().f_46443_) {
            return;
        }
        PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)this.m_9236_(), (double)this.m_20185_(), (double)y, (double)this.m_20189_(), (double)64.0), (IMessage)new S2CMessageStunGrenade(this.m_20185_(), y, this.m_20189_()));
        double diameter = Math.max((Double)Config.COMMON.stunGrenades.deafen.criteria.radius.get(), (Double)Config.COMMON.stunGrenades.blind.criteria.radius.get()) * 2.0 + 1.0;
        int minX = Mth.m_14107_((double)(this.m_20185_() - diameter));
        int maxX = Mth.m_14107_((double)(this.m_20185_() + diameter));
        int minY = Mth.m_14107_((double)(y - diameter));
        int maxY = Mth.m_14107_((double)(y + diameter));
        int minZ = Mth.m_14107_((double)(this.m_20189_() - diameter));
        int maxZ = Mth.m_14107_((double)(this.m_20189_() + diameter));
        Vec3 grenade = new Vec3(this.m_20185_(), y, this.m_20189_());
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ))) {
            if (entity.m_6128_()) continue;
            Vec3 eyes = entity.m_20299_(1.0f);
            Vec3 directionGrenade = grenade.m_82546_(eyes);
            double distance = directionGrenade.m_82553_();
            double angle = Math.toDegrees(Math.acos(entity.m_20252_(1.0f).m_82526_(directionGrenade.m_82541_())));
            if (this.calculateAndApplyEffect((MobEffect)ModEffects.DEAFENED.get(), Config.COMMON.stunGrenades.deafen.criteria, entity, grenade, eyes, distance, angle) && ((Boolean)Config.COMMON.stunGrenades.deafen.panicMobs.get()).booleanValue()) {
                entity.m_6703_(entity);
            }
            if (!this.calculateAndApplyEffect((MobEffect)ModEffects.BLINDED.get(), Config.COMMON.stunGrenades.blind.criteria, entity, grenade, eyes, distance, angle) || !((Boolean)Config.COMMON.stunGrenades.blind.blindMobs.get()).booleanValue() || !(entity instanceof Mob)) continue;
            ((Mob)entity).m_6710_(null);
        }
    }

    private boolean calculateAndApplyEffect(MobEffect effect, Config.EffectCriteria criteria, LivingEntity entity, Vec3 grenade, Vec3 eyes, double distance, double angle) {
        double angleMax = (Double)criteria.angleEffect.get() * 0.5;
        if (distance <= (Double)criteria.radius.get() && angleMax > 0.0 && angle <= angleMax && (effect != ModEffects.BLINDED.get() || !((Boolean)Config.COMMON.stunGrenades.blind.criteria.raytraceOpaqueBlocks.get()).booleanValue() || this.rayTraceOpaqueBlocks(this.m_9236_(), eyes, grenade, false, false, false) == null)) {
            int durationBlinded = (int)Math.round((double)((Integer)criteria.durationMax.get()).intValue() - (double)((Integer)criteria.durationMax.get() - (Integer)criteria.durationMin.get()) * (distance / (Double)criteria.radius.get()));
            durationBlinded = (int)((double)durationBlinded * (1.0 - angle * (1.0 - (Double)criteria.angleAttenuationMax.get()) / angleMax));
            entity.m_7292_(new MobEffectInstance(effect, durationBlinded, 0, false, false));
            return !(entity instanceof Player);
        }
        return false;
    }

    @Nullable
    public HitResult rayTraceOpaqueBlocks(Level world, Vec3 start, Vec3 end, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(start.f_82479_) || Double.isNaN(start.f_82480_) || Double.isNaN(start.f_82481_))) {
            if (!(Double.isNaN(end.f_82479_) || Double.isNaN(end.f_82480_) || Double.isNaN(end.f_82481_))) {
                BlockHitResult raytraceresult;
                int startZ;
                int startY;
                int endX = Mth.m_14107_((double)end.f_82479_);
                int endY = Mth.m_14107_((double)end.f_82480_);
                int endZ = Mth.m_14107_((double)end.f_82481_);
                int startX = Mth.m_14107_((double)start.f_82479_);
                BlockPos pos = new BlockPos(startX, startY = Mth.m_14107_((double)start.f_82480_), startZ = Mth.m_14107_((double)start.f_82481_));
                BlockState stateInside = world.m_8055_(pos);
                if (!(stateInside.m_60739_((BlockGetter)world, pos) == 0 || ignoreBlockWithoutBoundingBox && stateInside.m_60812_((BlockGetter)world, pos) == Shapes.m_83040_() || (raytraceresult = world.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this))) == null)) {
                    return raytraceresult;
                }
                HitResult raytraceresult2 = null;
                int limit = 200;
                while (limit-- >= 0) {
                    BlockState state;
                    Direction direction;
                    if (Double.isNaN(start.f_82479_) || Double.isNaN(start.f_82480_) || Double.isNaN(start.f_82481_)) {
                        return null;
                    }
                    if (startX == endX && startY == endY && startZ == endZ) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean completedX = true;
                    boolean completedY = true;
                    boolean completedZ = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (endX > startX) {
                        d0 = startX + 1;
                    } else if (endX < startX) {
                        d0 = startX;
                    } else {
                        completedX = false;
                    }
                    if (endY > startY) {
                        d1 = startY + 1;
                    } else if (endY < startY) {
                        d1 = startY;
                    } else {
                        completedY = false;
                    }
                    if (endZ > startZ) {
                        d2 = startZ + 1;
                    } else if (endZ < startZ) {
                        d2 = startZ;
                    } else {
                        completedZ = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = end.f_82479_ - start.f_82479_;
                    double d7 = end.f_82480_ - start.f_82480_;
                    double d8 = end.f_82481_ - start.f_82481_;
                    if (completedX) {
                        d3 = (d0 - start.f_82479_) / d6;
                    }
                    if (completedY) {
                        d4 = (d1 - start.f_82480_) / d7;
                    }
                    if (completedZ) {
                        d5 = (d2 - start.f_82481_) / d8;
                    }
                    if (d3 == 0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == 0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == 0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        direction = endX > startX ? Direction.WEST : Direction.EAST;
                        start = new Vec3(d0, start.f_82480_ + d7 * d3, start.f_82481_ + d8 * d3);
                    } else if (d4 < d5) {
                        direction = endY > startY ? Direction.DOWN : Direction.UP;
                        start = new Vec3(start.f_82479_ + d6 * d4, d1, start.f_82481_ + d8 * d4);
                    } else {
                        direction = endZ > startZ ? Direction.NORTH : Direction.SOUTH;
                        start = new Vec3(start.f_82479_ + d6 * d5, start.f_82480_ + d7 * d5, d2);
                    }
                    if ((state = world.m_8055_(pos = new BlockPos(startX = Mth.m_14107_((double)start.f_82479_) - (direction == Direction.EAST ? 1 : 0), startY = Mth.m_14107_((double)start.f_82480_) - (direction == Direction.UP ? 1 : 0), startZ = Mth.m_14107_((double)start.f_82481_) - (direction == Direction.SOUTH ? 1 : 0)))).m_60739_((BlockGetter)world, pos) == 0 || ignoreBlockWithoutBoundingBox && !state.m_60713_(Blocks.f_50142_) && state.m_60812_((BlockGetter)world, pos) == Shapes.m_83040_()) continue;
                    return world.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }
}

