/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.handlers;

import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.network.ServerPlayHandler;
import com.nukateam.ntgl.common.util.trackers.ShootTracker;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl")
public class ServerEvent {
    @SubscribeEvent
    public static void onServerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase != TickEvent.Phase.START) {
            ServerEvent.handleAutoReload((ServerPlayer)event.player, InteractionHand.MAIN_HAND);
            ServerEvent.handleAutoReload((ServerPlayer)event.player, InteractionHand.OFF_HAND);
        }
    }

    private static void handleAutoReload(ServerPlayer player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ShootTracker shootTracker = ShootTracker.getShootTracker((LivingEntity)player, hand);
        Boolean isReloading = (Boolean)ModSyncedDataKeys.getReloadKey(hand).getValue((Entity)player);
        if (!player.m_7500_() && GunModifierHelper.isGun(stack) && !isReloading.booleanValue() && GunModifierHelper.isAutoReloading(new GunData(stack, (LivingEntity)player)) && shootTracker.cooldownEnded() && !GunStateHelper.hasAmmo(stack)) {
            ServerPlayHandler.reloadGun(hand, player);
        }
    }
}

