/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.nukateam.ntgl.common.network.ServerPlayHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class C2SMessageShoot
extends PlayMessage<C2SMessageShoot> {
    private int shooterId;
    private float rotationYaw;
    private float rotationPitch;
    private float randP;
    private float randY;
    private boolean isMainHand;

    public C2SMessageShoot() {
    }

    public C2SMessageShoot(int shooterId, float yaw, float pitch, float randP, float randY, boolean isMainHand) {
        this.shooterId = shooterId;
        this.rotationPitch = pitch;
        this.rotationYaw = yaw;
        this.randP = randP;
        this.randY = randY;
        this.isMainHand = isMainHand;
    }

    public void encode(C2SMessageShoot messageShoot, FriendlyByteBuf buffer) {
        buffer.writeInt(messageShoot.shooterId);
        buffer.writeFloat(messageShoot.rotationYaw);
        buffer.writeFloat(messageShoot.rotationPitch);
        buffer.writeFloat(messageShoot.randP);
        buffer.writeFloat(messageShoot.randY);
        buffer.writeBoolean(messageShoot.isMainHand);
    }

    public C2SMessageShoot decode(FriendlyByteBuf buffer) {
        return new C2SMessageShoot(buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean());
    }

    public void handle(C2SMessageShoot messageShoot, MessageContext supplier) {
        supplier.execute(() -> {
            Entity shooter;
            ServerPlayer player = supplier.getPlayer();
            if (player != null && (shooter = player.m_9236_().m_6815_(messageShoot.shooterId)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)shooter;
                ServerPlayHandler.handleShoot(messageShoot, livingEntity);
            }
        });
        supplier.setHandled(true);
    }

    public boolean isMainHand() {
        return this.isMainHand;
    }

    public float getRotationYaw() {
        return this.rotationYaw;
    }

    public float getRotationPitch() {
        return this.rotationPitch;
    }
}

