/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.nukateam.ntgl.common.data.enums.DeathType;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;

public class S2CMessageEntityDeath
extends PlayMessage<S2CMessageEntityDeath> {
    int entityId;
    int deathTypeId;
    float motionX;
    float motionY;
    float motionZ;

    public S2CMessageEntityDeath() {
    }

    public S2CMessageEntityDeath(int entityId, int deathTypeId, float motionX, float motionY, float motionZ) {
        this.entityId = entityId;
        this.deathTypeId = deathTypeId;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public S2CMessageEntityDeath(LivingEntity entity, DeathType deathtype) {
        this.entityId = entity.m_19879_();
        this.deathTypeId = Objects.requireNonNullElse(deathtype, DeathType.DEFAULT).getValue();
        this.motionX = (float)entity.f_19854_;
        this.motionY = (float)entity.f_19855_;
        this.motionZ = (float)entity.f_19856_;
    }

    public void encode(S2CMessageEntityDeath message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.writeInt(message.deathTypeId);
        buf.writeFloat(message.motionX);
        buf.writeFloat(message.motionY);
        buf.writeFloat(message.motionZ);
    }

    public S2CMessageEntityDeath decode(FriendlyByteBuf buf) {
        return new S2CMessageEntityDeath(buf.readInt(), buf.readInt(), buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public void handle(S2CMessageEntityDeath message, MessageContext supplier) {
        supplier.execute(() -> {});
        supplier.setHandled(true);
    }
}

