/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.util;

import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.attachment.impl.Scope;
import com.nukateam.ntgl.common.data.config.AmmoConfig;
import com.nukateam.ntgl.common.data.config.ProjectileConfig;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.data.config.gun.Modules;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.debug.Debug;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.foundation.item.attachment.ScopeItem;
import com.nukateam.ntgl.common.foundation.item.interfaces.IThrowable;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.SetUtils;
import com.nukateam.ntgl.modules.enchantment.ModEnchantments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public class GunStateHelper {
    public static final String AMMO_TAG = "Ammo";
    public static final String FIRE_MODE = "FireMode";
    public static final String ATTACHMENTS = "Attachments";

    public static void switchAmmo(GunData data) {
        Set<AmmoHolder> ammoItems = GunModifierHelper.getAmmoItems(data);
        AmmoHolder current = GunStateHelper.getCurrentAmmo(data);
        AmmoHolder newAmmo = SetUtils.cycleSet(ammoItems, current);
        GunStateHelper.setCurrentAmmo(data, newAmmo.getId());
    }

    public static ResourceKey<DamageType> getDamageType(GunData data) {
        ProjectileConfig ammo = GunStateHelper.getProjectileConfig(data);
        return ammo.getDamageType();
    }

    public static int getAmmoCount(GunData data) {
        CompoundTag tag = data.gun.m_41784_();
        return tag.m_128451_("AmmoCount");
    }

    public static void addAmmo(GunData data, int amount) {
        CompoundTag tag = data.gun.m_41784_();
        int maxAmmo = GunModifierHelper.getMaxAmmo(data);
        int result = Math.min(tag.m_128451_("AmmoCount") + amount, maxAmmo);
        tag.m_128405_("AmmoCount", result);
        data.gun.m_41751_(tag);
    }

    public static void setCurrentAmmo(GunData data, ResourceLocation ammo) {
        CompoundTag tag = data.gun.m_41784_();
        tag.m_128359_(AMMO_TAG, ammo.toString());
        data.gun.m_41751_(tag);
    }

    public static AmmoHolder getCurrentAmmo(GunData data) {
        CompoundTag tag = data.gun.m_41784_();
        if (tag.m_128425_(AMMO_TAG, 8)) {
            String ammoId = tag.m_128461_(AMMO_TAG);
            return AmmoHolder.getType(ammoId);
        }
        Set<AmmoHolder> ammoItems = GunModifierHelper.getAmmoItems(data);
        return SetUtils.getFirst(ammoItems);
    }

    public static AmmoHolder getCurrentAmmoWithoutCheck(GunData data) {
        CompoundTag tag = data.gun.m_41784_();
        Set<AmmoHolder> ammoItems = GunModifierHelper.getAmmoItems(data);
        if (tag.m_128425_(AMMO_TAG, 8)) {
            return AmmoHolder.getType(tag.m_128461_(AMMO_TAG));
        }
        AmmoHolder firstAmmo = SetUtils.getFirst(ammoItems);
        GunStateHelper.setCurrentAmmo(data, firstAmmo.getId());
        return firstAmmo;
    }

    public static boolean isAcceptable(GunData gunData, ItemStack item) {
        return GunStateHelper.getCurrentAmmo(gunData).isAcceptable(item);
    }

    public static AmmoConfig getAmmoConfig(GunData data) {
        ResourceLocation ammoId = GunStateHelper.getCurrentAmmo(data).getId();
        return GunModifierHelper.getAmmoConfig(ammoId, data);
    }

    @NotNull
    public static ProjectileConfig getProjectileConfig(GunData data) {
        ResourceLocation ammoId = GunStateHelper.getCurrentAmmoWithoutCheck(data).getId();
        return GunModifierHelper.getProjectileConfig(ammoId, data);
    }

    public static void switchFireMode(GunData data) {
        Set<FireMode> fireModes = GunModifierHelper.getFireModes(data);
        FireMode current = GunStateHelper.getFireMode(data);
        FireMode newFireMode = SetUtils.cycleSet(fireModes, current);
        GunStateHelper.setFireMode(data, newFireMode);
    }

    public static void setFireMode(GunData data, FireMode fireMode) {
        CompoundTag tag = data.gun.m_41784_();
        tag.m_128359_(FIRE_MODE, fireMode.toString());
        data.gun.m_41751_(tag);
    }

    public static FireMode getFireMode(GunData data) {
        Set<FireMode> fireModes = GunModifierHelper.getFireModes(data);
        FireMode currentFireMode = GunStateHelper.getFireMode(data.gun);
        if (currentFireMode == null || !fireModes.contains(currentFireMode)) {
            GunStateHelper.setFireMode(data, SetUtils.getFirst(fireModes));
            return SetUtils.getFirst(fireModes);
        }
        return currentFireMode;
    }

    @Nullable
    private static FireMode getFireMode(ItemStack gun) {
        CompoundTag tag = gun.m_41784_();
        if (tag.m_128425_(FIRE_MODE, 8)) {
            return FireMode.getType(tag.m_128461_(FIRE_MODE));
        }
        return null;
    }

    public static boolean isMaxAmmo(GunData data) {
        int maxAmmo;
        int ammo = GunStateHelper.getAmmoCount(data);
        return ammo == (maxAmmo = GunModifierHelper.getMaxAmmo(data));
    }

    public static void setAmmo(ItemStack gunStack, int amount) {
        CompoundTag tag = gunStack.m_41784_();
        tag.m_128405_("AmmoCount", amount);
    }

    public static void setMaxAmmo(GunData data) {
        GunStateHelper.setAmmo(data.gun, GunModifierHelper.getMaxAmmo(data));
    }

    public static boolean hasAmmo(ItemStack gunStack) {
        CompoundTag tag = gunStack.m_41784_();
        return tag.m_128471_("IgnoreAmmo") || tag.m_128451_("AmmoCount") > 0;
    }

    public static void fillAmmo(GunData data) {
        Item item = data.gun.m_41720_();
        if (item instanceof WeaponItem) {
            WeaponItem weaponItem = (WeaponItem)item;
            CompoundTag tag = data.gun.m_41784_();
            int maxAmmo = GunModifierHelper.getMaxAmmo(data);
            tag.m_128405_("AmmoCount", maxAmmo);
        }
    }

    public static float getAdditionalDamage(ItemStack gunStack) {
        CompoundTag tag = gunStack.m_41784_();
        return tag.m_128457_("AdditionalDamage");
    }

    public static ArrayList<ItemStack> getAttachmentItems(ItemStack gun) {
        CompoundTag compound = gun.m_41783_();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (compound != null && compound.m_128425_(ATTACHMENTS, 10)) {
            CompoundTag attachment = compound.m_128469_(ATTACHMENTS);
            for (String slot : attachment.m_128431_()) {
                if (!attachment.m_128425_(slot, 10)) continue;
                result.add(ItemStack.m_41712_((CompoundTag)attachment.m_128469_(slot)));
            }
        }
        return result;
    }

    public static ItemStack getAttachmentItem(AttachmentType type, ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_(ATTACHMENTS, 10) && (attachment = compound.m_128469_(ATTACHMENTS)).m_128425_(type.toString(), 10)) {
            return ItemStack.m_41712_((CompoundTag)attachment.m_128469_(type.toString()));
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasScopeOverlay(ItemStack gun) {
        ScopeItem scope = GunStateHelper.getScopeItem(gun);
        return scope != null && ((Scope)scope.getProperties()).hasOverlay();
    }

    @Nullable
    public static ScopeItem getScopeItem(ItemStack gun) {
        ItemStack attachment = GunStateHelper.getAttachmentItem(AttachmentType.SCOPE, gun);
        if (!attachment.m_41619_()) {
            return (ScopeItem)attachment.m_41720_();
        }
        return null;
    }

    public static boolean hasAttachmentEquipped(ItemStack stack, AttachmentType type) {
        Gun gun = GunModifierHelper.getGun(stack);
        if (!gun.canAttachType(type, gun)) {
            return false;
        }
        CompoundTag compound = stack.m_41783_();
        if (compound != null && compound.m_128425_(ATTACHMENTS, 10)) {
            CompoundTag attachment = compound.m_128469_(ATTACHMENTS);
            return attachment.m_128425_(type.toString(), 10);
        }
        return false;
    }

    public static ItemStack getScopeStack(ItemStack gun) {
        return GunStateHelper.getAttachmentItem(AttachmentType.SCOPE, gun);
    }

    @Nullable
    public static Scope getScope(ItemStack gun) {
        ItemStack scopeStack = GunStateHelper.getScopeStack(gun);
        Item item = scopeStack.m_41720_();
        if (item instanceof ScopeItem) {
            ScopeItem scopeItem = (ScopeItem)item;
            if (Ntgl.isDebugging()) {
                return Debug.getScope(scopeItem);
            }
            return (Scope)scopeItem.getProperties();
        }
        return null;
    }

    public static float getFovModifier(ItemStack stack, Gun modifiedGun) {
        Modules.Zoom zoom;
        Scope scope;
        float modifier = 0.0f;
        if (GunStateHelper.hasAttachmentEquipped(stack, AttachmentType.SCOPE) && (scope = GunStateHelper.getScope(stack)) != null) {
            if (scope.getFovModifier() < 1.0f) {
                return Mth.m_14036_((float)scope.getFovModifier(), (float)0.01f, (float)1.0f);
            }
            modifier -= scope.getFovModifier();
        }
        return (zoom = modifiedGun.getModules().getZoom()) != null ? modifier + zoom.getFovModifier() : 0.0f;
    }

    public static boolean isAmmoIgnored(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128425_("IgnoreAmmo", 1);
    }

    public static void saveAttachments(GunData data, Collection<ItemStack> attachments) {
        ItemStack weapon = data.gun;
        CompoundTag attachmentsTag = new CompoundTag();
        for (ItemStack itemStack : attachments) {
            Item item = itemStack.m_41720_();
            if (!(item instanceof IAttachment)) continue;
            IAttachment attachment = (IAttachment)item;
            AttachmentType tagKey = attachment.getType();
            attachmentsTag.m_128365_(tagKey.toString(), (Tag)itemStack.m_41739_(new CompoundTag()));
        }
        CompoundTag tag = weapon.m_41784_();
        tag.m_128365_(ATTACHMENTS, (Tag)attachmentsTag);
    }

    private static boolean containsItem(Collection<ItemStack> whereFind, Collection<ItemStack> whatFind) {
        for (ItemStack att : whatFind) {
            if (GunStateHelper.contains(whereFind, att)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Collection<ItemStack> list, ItemStack toFind) {
        for (ItemStack stack : list) {
            if (stack.m_41720_() != toFind.m_41720_()) continue;
            return true;
        }
        return false;
    }

    public static void saveAttachment(ItemStack weapon, ItemStack attachmentStack) {
        Item item;
        CompoundTag tag = weapon.m_41784_();
        CompoundTag attachmentsTag = new CompoundTag();
        if (tag.m_128425_(ATTACHMENTS, 10)) {
            attachmentsTag = tag.m_128469_(ATTACHMENTS);
        }
        if ((item = attachmentStack.m_41720_()) instanceof IAttachment) {
            IAttachment attachment = (IAttachment)item;
            String tagKey = attachment.getType().toString();
            attachmentsTag.m_128365_(tagKey, (Tag)attachmentStack.m_41739_(new CompoundTag()));
        }
        tag.m_128365_(ATTACHMENTS, (Tag)attachmentsTag);
    }

    public static void consumeAmmo(GunData data) {
        LivingEntity shooter = data.shooter;
        ItemStack heldItem = data.gun;
        if (shooter != null && heldItem != null) {
            int level;
            int ammoPerShot = GunModifierHelper.getAmmoPerShot(data);
            FireMode fireMode = GunStateHelper.getFireMode(data);
            int multishotAmount = GunModifierHelper.getMultishotAmount(data);
            int ammoCount = GunStateHelper.getAmmoCount(data);
            if (fireMode == FireMode.MULTI && multishotAmount > 1) {
                multishotAmount = Math.min(ammoCount, multishotAmount);
                ammoPerShot *= multishotAmount;
            }
            if ((level = heldItem.getEnchantmentLevel((Enchantment)ModEnchantments.RECLAIMED.get())) == 0 || shooter.m_9236_().f_46441_.m_188503_(4 - Mth.m_14045_((int)level, (int)1, (int)2)) != 0) {
                int remainingAmmo = Math.max(0, ammoCount - ammoPerShot);
                GunStateHelper.setAmmo(heldItem, remainingAmmo);
            }
        }
    }

    public static int getEquipTime(ItemStack slot, LivingEntity shooter) {
        int equipTime = 0;
        if (slot.m_41720_() instanceof IWeapon) {
            GunData data = new GunData(slot, shooter);
            equipTime = GunModifierHelper.getEquipTime(data);
        } else {
            Item item = slot.m_41720_();
            if (item instanceof IThrowable) {
                IThrowable throwable = (IThrowable)item;
                equipTime = throwable.getConfig().getGeneral().getEquipTime();
            }
        }
        return equipTime;
    }
}

