/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.props;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.zeith.hammerlib.abstractions.props.Key;

public class KeyMap {
    protected final Map<Key<?>, Object> values;

    public KeyMap(Supplier<Map<Key<?>, Object>> mapSupplier) {
        this.values = mapSupplier.get();
    }

    public <T> Optional<T> opt(Key<T> key) {
        return Optional.ofNullable(this.get(key));
    }

    public <T> T get(Key<T> key) {
        return (T)this.values.get(key);
    }

    public <T> T getOrDefault(Key<T> key, T defaultValue) {
        return (T)this.values.getOrDefault(key, defaultValue);
    }

    public <T> T getOrSupply(Key<T> key, Supplier<T> defaultValue) {
        Object t = this.values.get(key);
        return (T)(t != null ? t : defaultValue.get());
    }

    public <T> T computeIfAbsent(Key<T> key, Supplier<T> defaultValue) {
        return (T)this.values.computeIfAbsent(key, (? super K k) -> defaultValue.get());
    }

    public <T> T put(Key<T> key, T value) {
        return (T)this.values.put(key, value);
    }

    public <T> KeyMap with(Key<T> key, T value) {
        this.put(key, value);
        return this;
    }

    public KeyMap withAll(KeyMap other) {
        this.values.putAll(other.values);
        return this;
    }

    public static KeyMap createHash() {
        return new KeyMap(HashMap::new);
    }

    public static KeyMap createConcurrentHash() {
        return new KeyMap(ConcurrentHashMap::new);
    }
}

